package com.yizhi.system.application.model;

import java.util.HashMap;
import java.util.Map;

import lombok.Data;

/**
 * 授权返回类型
 * 若是企业管理员（admin = true）
 * 那么，给 companyId 赋值，
 *
 * @Author: shengchenglong
 * @Date: 2018/3/20 15:10
 */
@Data
public class AuthorityModel {

    /**
     * 是否是整个管理后台的admin
     */
    private Boolean admin;

    /**
     * 管理的企业的id
     */
    private Long companyId;

    /**
     * 若不是企业管理员（admin = false）
     * 从库中查出的数据权限集合
     * key: url
     * value: 权限model
     */
    private Map<String, AuthorityUrlModel> authorityMuduleModels = new HashMap<String, AuthorityUrlModel>();
}
