package com.yizhi.system.application.model;

import java.util.HashSet;
import java.util.Set;

import lombok.Data;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/20 16:38
 */
@Data
public class AuthorityUrlModel {

    /**
     * 是否被授权管理当前url下，企业下所有的公司（总公司，分公司，各部门）
     * 管理所有当前企业下的（此时，companyId需要赋值）
     */
    private Boolean admin;

    private Long companyId;

    /**
     * 所管理的组织（分公司或部门）id
     */
    private Set<Long> orgIds = new HashSet<Long>();

    /**
     * 所管理的站点id（一个站点对应一个组织）
     */
    private Set<Long> siteIds = new HashSet<Long>();
}
