package com.yizhi.system.application.request;

import com.yizhi.system.application.enums.SiteNoticeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

@Data
@ApiModel
public class QuerySiteProtectResq {

    @ApiModelProperty(value = "维护名称",name = "name")
    private String name;

    @ApiModelProperty(value = "维护信息状态",name = "siteProtectStatus",allowableValues = "1未开始,2进行中,3已结束")
    private String siteProtectStatus;

    @ApiModelProperty(value = "维护方式",name = "siteNoticeEnum",allowableValues = " INNER_NOTICE 站内通知,CLOSE_NOTICE 停站通知")
    private SiteNoticeEnum siteNoticeEnum;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "开始时间",name = "startTime")
    private Date startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
    @ApiModelProperty(value = "结束时间",name = "endTime")
    private Date endTime;

    @ApiModelProperty(name = "当前页码", value = "默认1")
    private Integer pageNo;
    @ApiModelProperty(name = "每页大小", value = "默认10")
    private Integer pageSize;
}
