package com.yizhi.system.application.request;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

@Data
@Api(value = "站点维护删除请求体")
public class SiteProtectDelReq {

    @ApiModelProperty(value = "站点维护id")
    private String siteProtectId;

    @ApiModelProperty(value = "维护通知id")
    private String noticeId;


    //校验参数
    public boolean isValid(){
        try {
            boolean a = Long.parseLong(noticeId)>0;
            boolean b = Long.parseLong(siteProtectId)>0;
            return a&b;
        } catch (Exception e) {

            return false;
        }
    }

    public Long getSiteProtectId() {
        return StringUtils.isBlank(siteProtectId)?null:Long.parseLong(siteProtectId);
    }

    public Long getNoticeId() {
        return StringUtils.isBlank(noticeId)?null:Long.parseLong(noticeId);
    }
}
