package com.yizhi.system.application.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.lang3.StringUtils;

@Data
@ApiModel
@Log4j2
public class SiteResq {

    @ApiModelProperty(value = "主键id")
    private String id;

    @ApiModelProperty(value = "站点id")
    private String siteId;

    @ApiModelProperty(value = "站点名字")
    private String siteName;

    @ApiModelProperty(value = "站点编码")
    private String siteCode;

    @ApiModelProperty(value = "公司Id")
    private String companyId;

    @ApiModelProperty(value = "公司名字")
    private String companyName;

    @ApiModelProperty(value = "公司编码")
    private String companyCode;

    public Long getId() {
        log.info(this.id);
        return StringUtils.isEmpty(id)?null:Long.parseLong(id.trim());
    }

    public Long getSiteId() {
        return StringUtils.isBlank(siteId)?null:Long.parseLong(siteId);
    }


    public Long getCompanyId() {
        return StringUtils.isBlank(companyId)?null:Long.parseLong(companyId);
    }
}
