package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.model.AuthAccountSiteModel;
import com.yizhi.system.application.vo.SiteVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/22 16:36
 */
@FeignClient(value = "system", contextId = "AuthClient")
public interface AuthClient {

    /**
     * 管理端：可以管理的站点列表
     *
     * @param accountId
     * @return
     */
    @GetMapping("/manage/authz/site/access/list")
    List<SiteVO> getAccessSite(@RequestParam("accountId") Long accountId);

    /**
     * 管理端：是否可以访问一个站点
     *
     * @param accountId
     * @param siteId
     * @return
     */
    @GetMapping("/manage/authz/site/access")
    Boolean isAccessToSite(@RequestParam("companyId") Long companyId, @RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId);

    /**
     * 管理端：指定站点的数据权限接口
     *
     * @param accountId
     * @param siteId
     * @return
     */
    @GetMapping("/manage/authz/site/get")
    AuthAccountSiteModel getSiteAutho(@RequestParam("companyId") Long companyId,
                                      @RequestParam("companyCode") String companyCode,
                                      @RequestParam("accountId") Long accountId,
                                      @RequestParam("siteId") Long siteId,
                                      @RequestParam("key") String key);

    /**
     * 管理端：指定站点url的管辖范围
     *
     * @param orgIds
     * @return
     */
    @GetMapping("/manage/authz/site/url/get")
    Set<Long> getSiteUrlAutho(@RequestParam("companyId") Set<Long> orgIds);

    /**
     * 学员端：是否可以访问一个站点
     *
     * @param companyId
     * @param companyCode
     * @param accountId
     * @param siteId
     * @return
     */
    @GetMapping("/manage/authz/site/access/front")
    Boolean isAccessToSiteFront(@RequestParam("companyId") Long companyId,
                                @RequestParam("accountId") Long accountId,
                                @RequestParam("companyCode") String companyCode,
                                @RequestParam("siteId") Long siteId);

    @GetMapping("/manage/authz/site/relationIds/front")
    List<Long> getRelationIds(@RequestParam("companyId") Long companyId, @RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId);

    /**
     * 获取管理员
     * @param companyId
     * @param siteId
     * @param accountId
     * @return
     */
    @GetMapping(value = "/manage/role/get/adminIds")
    List<Long> getAdminIdsByAccountId(
            @RequestParam(name = "companyId") Long companyId,
            @RequestParam(name = "siteId") Long siteId,
            @RequestParam(name = "accountId") Long accountId
    );
}
