/**
 * 
 */
package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.system.application.vo.CompanyVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 日志服务远程调用接口
 * 注意:
 *    方法注解不要使用GetMapping,要使用RequestMapping
 *    如果是Get请求,方法参数要加上RequestParam,否则Feign组件会当作是Post请求
 * @author scotthu
 *
 * @date 2018年2月28日
 */

@FeignClient(value = "system", contextId = "CompanyClient")
public interface CompanyClient {

	/**
     * 根据站点code查询站点信息
	 * @param code 站点code
     * @return
     */
	@RequestMapping(value="/remote/company/name/get", method=RequestMethod.GET)
	CompanyVO findByCode(@RequestParam(value = "code") String code);

/*	@GetMapping(value = "/remote/company/orgs")
	List<TreeObjectVO> getOrgs(@RequestParam long companyId);*/

	/**
	 * 根据企业id查询企业的默认顶级站点信息
	 * @param companyId
	 * @return
	 */
	@GetMapping(value = "/remote/company/site/top/get")
	public SiteVO getTopSite(@RequestParam(value = "companyId") Long companyId);
	
	/**
     * 根据站点code查询站点信息
	 * @param code 站点code
     * @return
     */
	@RequestMapping(value="/remote/company/authcode/get", method=RequestMethod.GET)
	CompanyVO findByAuthCode(@RequestParam(value = "authcode") String authcode);

	/**
	 * 社群企业同步
	 * @param date
	 * @return
	 */
	@GetMapping(value="/remote/company/public/community/syncCompany")
	public String syncCompany(@RequestParam("indexTime") String indexTime);
}