
package com.yizhi.system.application.system.remote;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.vo.AccountVO;
import com.yizhi.system.application.vo.CompanySimpleVO;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.system.application.vo.TrSitePageVO;
import com.yizhi.system.application.vo.domain.Site;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * 站点feign接口
 *
 * @author Administrator
 */

@FeignClient(value = "system", contextId = "SiteClient")
public interface SiteClient {
    /**
     * 根据公司id查询所有的站点列表（如果不传企业id，就查询全部的可用站点信息）
     *
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/site/list/companyid", method = RequestMethod.GET)
    public List<SiteVO> findByCompanyId(@RequestParam(value = "companyId",required = false) Long companyId);

    /**
     * 根据站点code查询站点信息
     *
     * @param code
     * @return
     */
    @RequestMapping(value = "/remote/site/code/get", method = RequestMethod.GET)
    SiteVO findByName(@RequestParam(value = "code") String code, @RequestParam(value = "cid") Long cid);

    /**
     * 获取公司列表
     *
     * @return
     */
    @RequestMapping(value = "/remote/site/company/list", method = RequestMethod.GET)
    public List<CompanySimpleVO> list();


    /**
     * 根据站点id和企业id，查询站点下所有的用户信息
     *
     * @param siteId    站点id
     * @param companyId 企业Id
     * @return
     */
    @GetMapping(value = "/remote/site/account/list")
    public List<AccountVO> getSitAccount(@RequestParam(value = "siteId") Long siteId,
                                         @RequestParam(value = "companyId") Long companyId);

    /**
     * 根据站点id和企业id，查询站点下所有的用户信息总条数
     *
     * @param siteId    站点id
     * @param companyId 企业Id
     * @return
     */
    @GetMapping(value = "/remote/site/account/count")
    public int getSitAccountCount(@RequestParam(value = "siteId") Long siteId,
                                  @RequestParam(value = "companyId") Long companyId);

    /**
     * 根据站点id查询站点信息和站点的企业名
     *
     * @param ids
     * @return
     */
    @PostMapping(value = "/remote/site/siteIds/company/get")
    public List<SiteVO> selectByIds(@RequestBody List<Long> ids);

    /**
     * 根据站点id返回站点信息
     * @param id
     * @return
     */
    @GetMapping(value = "/remote/site/id/get")
    SiteVO selectById(@RequestParam("id") Long id);


    /**
     * 是否有站点范围权限（学员端）
     *
     * @param accountId
     * @param siteId
     * @param companyId
     * @return
     */
    @GetMapping(value = "/remote/site/isAccessToSite")
    public boolean isAccessToSite(@RequestParam(value = "accountId") long accountId,
                                  @RequestParam(value = "siteId") long siteId,
                                  @RequestParam(value = "companyId") long companyId);

    /**
     * 权限
     * @param accountId
     * @param siteId
     * @param companyId
     * @param companyCode
     * @return
     */
    @GetMapping(value = "/remote/site/accessToSite")
    boolean accessToSite(@RequestParam(value = "accountId") Long accountId,
                                  @RequestParam(value = "siteId") Long siteId,
                                  @RequestParam(value = "companyId") Long companyId,
                                  @RequestParam(value = "companyCode") String companyCode);

    /**
     * 自动成成未木云账号的站点访问权限设置
     *
     * @param siteId
     * @param accountId
     * @return
     */
    @GetMapping(value = "/remote/site/relateAccountSite")
    public boolean relateAccountSite(@RequestParam(name = "siteId") Long siteId,
                                     @RequestParam(name = "accountId") Long accountId,
                                     @RequestParam(name = "companyCode") String companyCode);

    /**
     * 是否是主站点
     *
     * @param siteId
     * @return true:是主站点，false:是子站点
     */
    @GetMapping(value = "/remote/site/isDefaultSite")
    Boolean isDefaultSite(@RequestParam(name = "siteId") Long siteId);

    @GetMapping("/remote/site/getAllSiteId")
    List<Long> getAllSiteId();
    
    @GetMapping("/remote/site/getSiteVOs")
    public List<SiteVO> getSiteVOs(@RequestParam(value = "companyId") long companyId);
    
    @GetMapping("/remote/site/getSiteIds")
    public List<Long> getSiteIds(@RequestParam(value = "companyId") long companyId);

    /**
     * 根据站点code和企业的id 获取站点详情
     * @param code
     * @param cid
     * @return
     */
    @GetMapping(value = "/remote/site/detail")
    SiteVO findSiteByCode(@RequestParam(value = "code") String code, @RequestParam(value = "cid") Long cid);

    /**
     * 分页根据code/name模糊查询
     * @param siteVO
     * @return
     */
    @PostMapping(value = "/remote/site/getPage")
    public Page<Site> getPage(@RequestBody TrSitePageVO siteVO);


    /**
     *     @ApiOperation(value = "学员可访问站点列表", response = SiteVO.class)
     * @return
     */
    @GetMapping(value = "/remote/site/front/list")
    public Set<Long> frontList();

    /**
     * 社群管辖区人员同步
     * @param date
     * @return
     */
    @GetMapping(value="/remote/site/public/community/syncSite")
    public String syncGroupMember(@RequestParam("indexTime") String indexTime);
}