/**
 *
 */
package com.yizhi.system.application.system.remote;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 站点feign接口
 *
 * @author Administrator
 */

@FeignClient(value = "system", contextId = "SiteProtectClient")
public interface SiteProtectClient {

    /**
     * 根据站点code查询站点信息
     *
     * @param siteCode
     * @return
     */
    @GetMapping(value = "/system/site/protect/code/{companyCode}/{siteCode}")
    String findProtectNoticeBySiteCode(@PathVariable("siteCode") String siteCode,@PathVariable("companyCode")String companyCode);


    /**
     * 查询学员所在站点的站内通知
     * @return response
     */
    @GetMapping(value = "/manage/site/protect/user/protect/list")
    String userProtectList();

}