package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.vo.StudentEditPermissionVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 15:58 2019/3/7
 * @Modified By
 */
@FeignClient(value = "system", contextId = "StudentEditPermissionClient")
public interface StudentEditPermissionClient {

    /**
     * 保存或者更新，根据id确定
     * @param vo
     * @return
     */
    @PostMapping(value = "/studentEditPermission/saveOrUpdate")
    StudentEditPermissionVO saveOrUpdate(@RequestBody StudentEditPermissionVO vo);

    /**
     * 根据站点获取用户配置的修改信息权限
     * @param siteId
     * @return
     */
    @GetMapping(value = "/studentEditPermission/get")
    StudentEditPermissionVO getBySiteId(@RequestParam("siteId") long siteId);
}
