/**
 * 
 */
package com.yizhi.system.application.system.remote;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.yizhi.core.application.file.domain.Template;

/**
 * 模板服务远程调用接口
 *
 * @date 2018年3月27日
 */

@FeignClient(value = "system", contextId = "TemplateClient")
public interface TemplateClient {

	/**
	 * 根据模板名查找模板
	 * @param name
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/remote/template/get", method=RequestMethod.GET)  
    public Template getByName(@RequestParam("name") String name) throws Exception;
}