package com.yizhi.system.application.utils.recursion;

/**
 * 使用尾递归的类,目的是对外统一方法
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 11:23 2018/4/24
 * @Modified By
 */
public class TailInvoke {

    public static <T> TailRecursion<T> call(final TailRecursion<T> nextFrame) {
        return nextFrame;
    }


    public static <T> TailRecursion<T> done(T value) {
        return new TailRecursion<T>() {
            @Override
            public TailRecursion<T> apply() {
                throw new Error("递归已经结束,非法调用apply方法");
            }

            @Override
            public boolean isFinished() {
                return true;
            }

            @Override
            public T getResult() {
                return value;
            }
        };
    }
}
