package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

/**
 * @Author: shengchenglong
 * @Date: 2018/7/24 15:29
 */
@ApiModel(
        value = "用户导出限制条件",
        description = "可以传递的参数列表：<br>" +
                "用户名：name<br>" +
                "工号：workNum<br>" +
                "姓名：fullName<br>" +
                "部门id：orgId（只能精确）<br>" +
                "邮箱：email<br>" +
                "用户状态：enabled（只能精确）:1启用,0停用")
@Data
public class AccountExportCondition {

    @ApiModelProperty("精确查询的条件")
    private Map<String, Object> accurateConditions;

    @ApiModelProperty("模糊查询的条件")
    private Map<String, Object> dimConditions;

}
