package com.yizhi.system.application.vo;

import java.util.Date;

import com.baomidou.mybatisplus.annotations.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 修改密码对象
 * @author yinyuyan 2018/04/25
 *
 */
@Data
@ApiModel(value = "AccountRegisterVO", description = "用户注册对象传输类")
public class AccountRegisterVO {
	
    @ApiModelProperty(value = "id")
	private String id;

    @ApiModelProperty(value = "账号名称")
	private String name;
    
    @ApiModelProperty(value = "密码")
	private String password;

    @ApiModelProperty(value = "头像")
	private String headPortrait;

    @ApiModelProperty(value = "座机")
	private String telephone;

    @ApiModelProperty(value = "手机号")
	private String mobile;

    @ApiModelProperty(value = "邮箱地址")
	private String email;

    @ApiModelProperty(value = "过期类型(1长期，2周期，3天数)")
	private Integer expiredType; 

    @ApiModelProperty(value = "开始时间")
	private Date startTime;

    @ApiModelProperty(value = "结束时间")
	private Date endTime;

    @ApiModelProperty(value = "性别(‘M’:男,'F':女)")
	private String sex;

    @ApiModelProperty(value = "职位")
	private String position;

    @ApiModelProperty(value = "微信")
	private String wechat;
    
    @ApiModelProperty(value = "微信图片")
	private String wechatPic;

    @ApiModelProperty(value = "有效天数")
	private Integer validDays;

    @ApiModelProperty(value = "全名")
	private String fullName;

    @ApiModelProperty(value = "工号")
	private String workNum;

    @ApiModelProperty(value = "账号描述")
	private String description;
    
    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "公司id")
    private Long companyId;


    @ApiModelProperty(value = "备注1")
    private String remarkFirst;

    @ApiModelProperty(value = "备注2")
    private String remarkSecond;

    @ApiModelProperty(value = "备注3")
    private String remarkThird;
    
    @ApiModelProperty(value = "sign",notes = "签名")
    private String sign;
    
    @ApiModelProperty(value = "salt",notes = "盐")
    private String salt;
}
