package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

/**
 * 修改密码对象
 * @author yinyuyan 2018/04/25
 *
 */
@Data
@ApiModel(value = "FirstLoginUpdateVO", description = "首次登陆更新账户")
public class FirstLoginUpdateVO {

/*    1 @NotEmpty :不能为null，且Size>0
    2  @NotNull:不能为null，但可以为empty,没有Size的约束
    3  @NotBlank:只用于String,不能为null且trim()之后size>0*/

    @ApiModelProperty(value = "accountId",notes = "账号id")
    //@NotNull
    //@Past(message = "生日不能是之后的日期")
    private Long accountId;

    @ApiModelProperty(value = "mobile",notes = "手机号")
    //@NotNull
    //@Range(min = 1, max = 200, message = "年龄范围应该在1-200内")
    //@Pattern(regexp = "[a-zA-Z]*", message = "密码只能是字母")
    private Long mobile;

    @ApiModelProperty(value = "smsVerifyCode",notes = "短信验证码")
    //@NotBlank(message = "用户名不能为空")
    //@Length(min = 4, max = 6, message = "密码长度为4-6位")
    private String smsVerifyCode;

    @ApiModelProperty(value = "password",notes = "密码")
    //@NotBlank
    //@Pattern(regexp = "[a-zA-Z0-9]*", message = "密码只能是字母数字")
    private String password;

    @ApiModelProperty(value = "confirmPassword",notes = "确认密码")
    //@NotBlank
    //@Pattern(regexp = "[a-zA-Z0-9]*", message = "密码只能是字母数字")
    private String confirmPassword;

    @ApiModelProperty(value = "smsSendRequestNo",notes = "短信验证码发送成功后返回的业务号（必须）")
    private String smsSendRequestNo;
    
    @ApiModelProperty(value = "sign",notes = "签名")
    private String sign;
    
    @ApiModelProperty(value = "salt",notes = "盐")
    private String salt;

}
