package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 18:24 2018/8/28
 * @Modified By
 */
@Data
@ApiModel(value = "LoginUserOrgExportVO", description = "按用户登陆导出报表信息")
public class LoginUserExportVO {

    /**
     * 用户id
     */
    @ApiModelProperty(value = "用户id")
    private Long userId;


    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String userName;

    /**
     * 用户姓名
     */
    @ApiModelProperty(value = "用户姓名")
    private String userFullName;

    /**
     * 员工工号
     */
    @ApiModelProperty(value = "员工工号")
    private String workNum;


    @ApiModelProperty(value = "部门id")
    private Long orgId;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String orgName;

    /**
     * 是否登陆（true：登陆，
     */
    @ApiModelProperty(value = "是否登陆（true：登陆，")
    private Boolean isLogin;

    /**
     * 用户状态
     */
    @ApiModelProperty(value = "用户状态")
    private String userStatus;

    /**
     * 最后登陆时间
     */
    @ApiModelProperty(value = "最后登陆时间")
    private String lastLoginDate;
    
    /**
     * 登录次数
     */
    @ApiModelProperty(value = "登录次数")
    private Long loginVisit;
    

    private List<String> upOrgNames;
}
