package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 18:24 2018/8/28
 * @Modified By
 */
@Data
@ApiModel(value = "LoginUserOrgExportVO", description = "按部门统计用户登陆导出报表信息")
public class LoginUserOrgExportVO {

    /**
     * 部门id
     */
    @ApiModelProperty(value = "部门id")
    private Long orgId;

    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码")
    private String orgCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称")
    private String orgName;

    /**
     * 总用户数
     */
    @ApiModelProperty(value = "总用户数")
    private Long userSumNum;

    /**
     * 总启用用户数
     */
    @ApiModelProperty(value = "总启用用户数")
    private Long enableUserNum;

    /**
     * 总停用用户数
     */
    @ApiModelProperty(value = "总停用用户数")
    private Long stopUserNum;

    /**
     * 当前用户状态 0 正常；1：未开启；2：锁定；3：过期；4：过时
     */
    @ApiModelProperty(value = "当前用户状态 0 正常；1：未开启；2：锁定；3：过期；4：过时")
    private String status;

    /**
     * 总登陆用户数
     */
    @ApiModelProperty(value = "总登陆用户数")
    private Long loginUserNum;
    
    
    /**
     * 总登陆人次
     */
    @ApiModelProperty(value = "总登陆人次")
    private Long loginVisit;

    private List<String> upOrgNames;


}
