package com.yizhi.system.application.vo;

import com.yizhi.system.application.enums.SiteNoticeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@ApiModel("通知信息")
@Data
public class NoticeVO {

	@ApiModelProperty(value = "通知id")
	private String id;

	@ApiModelProperty(value = "开始时间", name = "startTime")
	private String startTime;

	@ApiModelProperty(value = "结束时间", name = "endTime")
	private String endTime;

	@ApiModelProperty(value = "信息")
	private String message;

	@ApiModelProperty(name = "siteNoticeEnum", value = "维护方式")
	private SiteNoticeEnum siteNoticeEnum;

	@ApiModelProperty(name = "siteProtectStatus",value = "状态",allowableValues = "1未开始 2进行中 3已结束")
	private String siteProtectStatus;

	@ApiModelProperty(name = "deleteFlag", value = "关闭标识 0未关闭,1关闭 用于修改时删除标识")
	private boolean deleteFlag;

	public Long getId() {
		return StringUtils.isBlank(id)?null:Long.parseLong(id);
	}
}