package com.yizhi.system.application.vo;

import com.yizhi.core.application.context.RequestContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 17:11 2018/7/16
 * @Modified By
 */
@Api(tags = "ReportOrgReqVO", description = "组织部门人数查询请求参数对象")
@Data
public class ReportOrgReqVO {

    /**
     * 上下文信息
     */
    @NotNull
    @ApiModelProperty(value = "上下文信息")
    private RequestContext requestContext;

    /**
     * 搜索关键字（目前按名称模糊搜索）
     */
    @ApiModelProperty(value = "搜索关键字:部门名称")
    private String orgCodeOrOrgName;

    @ApiModelProperty(value = "第几页，不传查询全部")
    private Integer pageNo;

    @ApiModelProperty(value = "每页条数")
    private Integer pageSize=10;

}
