package com.yizhi.system.application.vo;

import java.util.List;

import javax.validation.constraints.NotNull;

import org.hibernate.validator.constraints.NotBlank;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 账号VO类
 *
 */
@ApiModel(value = "roleVO", description = "角色业务属性封装")
@Data
public class RoleVO {

	@ApiModelProperty(value = "角色信息唯一ID，新增时候不用传")
	private Long id;

	@ApiModelProperty(value = "角色名")
	@NotBlank
	private String name;

	@ApiModelProperty(value = "角色序号")
	@NotBlank
	private String code;

	@ApiModelProperty(value = "是否是站点默认管理员")
	private Boolean isSiteDefaultAdmin;

	@ApiModelProperty(value = "是否开通,1为开通，0为不开通")
	private Boolean enabled;

	@ApiModelProperty(value = "角色描述")
	private String description;

	@ApiModelProperty(value = "关联用户数，默认值为0)")
	private Integer relevanceNum;
	
    @ApiModelProperty(value = "模块id列表")
    private List<Long> moduleIds;
    
    @ApiModelProperty(value = "管辖区id列表")
    private List<Long> groupIds;

	@ApiModelProperty(value = "被管理的管理员的用户 id")
    private List<Long> managerAccountIds;

	@ApiModelProperty(value = "被管理的管理员的用户名")
	private String managerAccountNames;
}