package com.yizhi.system.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * <p>
 * 站点维护-自定义选择站点查询返回实体
 * </p>
 */
@Data
@Api(tags = "SiteProtectDefinedVO")
public class SiteProtectDefinedVO {

    @ApiModelProperty(value = "id")
	private String id;

    @ApiModelProperty(value = "站点名称")
	private String name;

	@ApiModelProperty(value = "编码")
	private String code;

	@ApiModelProperty(value = "公司id")
	private String companyId;

	@ApiModelProperty(value = "公司名称")
	private String companyName;

	@ApiModelProperty(value = "公司Code")
	private String companyCode;

	public Long getId() {
		return StringUtils.isBlank(id)?null:Long.parseLong(id);
	}

	public Long getCompanyId() {
		return StringUtils.isBlank(companyId)?null:Long.parseLong(companyId);
	}
}
