package com.yizhi.system.application.vo;

import com.yizhi.system.application.enums.SiteNoticeEnum;
import com.yizhi.system.application.enums.SiteProtectEnum;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 站点维护通知返回体
 *
 */
@Data
public class SiteProtectNoticeVO implements Serializable {

    private String id;

    /**
     * site_protect id
     */
    private String siteProtectId;

    /**
     * 通知类型  INNER站内 CLOSE关站
     */
    private SiteNoticeEnum noticeType;

    /**
     * 通知内容
     */
    private String message;


    /**
     * 站点类型， ALL 所有站点， PART 自选站点
     */
    private SiteProtectEnum siteType;

    private Date startTime;

    private Date endTime;

    private static final long serialVersionUID = 1L;

    public Long getId() {
        return StringUtils.isBlank(id)?null:Long.parseLong(id);
    }

    public Long getSiteProtectId() {
        return StringUtils.isBlank(siteProtectId)?null:Long.parseLong(siteProtectId);
    }
}
