package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;

/**
 * @ClassName RuleTemplateSave
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-11-28 11:28
 * @Version 1.0
 */
@Data
@ApiModel("规则item - vo")
public class SystemRuleItemVo {

    @ApiModelProperty("规则项id")
    private Long id;

    @ApiModelProperty("规则id")
    private Long ruleId;

    @ApiModelProperty("业务类型")
    private String business;

    @ApiModelProperty("属性类型 属性名称")
    private String propertyName;

    @ApiModelProperty(value = "target_val 为id时，记录name，回显用")
    private String name;

    @ApiModelProperty("关系类型 1:contains; 2:notContains; 3:equals; 4:notEquals;")
    private String relation;

    @ApiModelProperty("匹配值")
    private String targetVal;

    @ApiModelProperty("排序")
    private Integer sort;

    @ApiModelProperty("逻辑关系  and或者or")
    private String andOr;

    @ApiModelProperty("规则与规则之间的逻辑关系  and或者or")
    private String rulesAndOr;


}
