package com.yizhi.system.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 站点
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "TrSitePageVO", description = "站点传输对象")
public class TrSitePageVO {

    @ApiModelProperty(value = "站点名称/编码")
    private String keyword;

    @ApiModelProperty(value = "是否开通")
    private Boolean enabled;

    @ApiModelProperty(value = "成员类型(1:子站点2:业务站点)")
    private Integer type;

    @ApiModelProperty(value = "第几页")
    private Integer pageNo = 1;

    @ApiModelProperty(value = "页内条数")
    private Integer pageSize = 10;
}

