package com.yizhi.system.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 用户
 * </p>
 *
 * @author moniyin
 * @since 2018-03-12
 */
@Data
@ApiModel(value = "Account", description = "用户")
public class Account {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "账号名称")
    private String name;

    @ApiModelProperty(value = "密码")
    private String password;

    @ApiModelProperty(value = "头像")
    private String headPortrait;

    @ApiModelProperty(value = "是否开通")
    private Boolean enabled;

    @ApiModelProperty(value = "是否锁定")
    private Boolean locked;

    @ApiModelProperty(value = "部门id")
    private Long orgId;

    @ApiModelProperty(value = "租户(公司)id")
    private Long companyId;

    @ApiModelProperty(value = "座机")
    private String telephone;

    @ApiModelProperty(value = "手机号")
    private String mobile;

    @ApiModelProperty(value = "邮箱地址")
    private String email;

    @ApiModelProperty(value = "过期类型(长期，周期，天数)")
    private Integer expiredType;

    @ApiModelProperty(value = "是否是第一次登录")
    private Boolean firstLogin;

    @ApiModelProperty(value = "第一次登录时间")
    private Date firstLoginTime;

    @ApiModelProperty(value = "上一次登录时间")
    private Date lastLoginTime;

    @ApiModelProperty(value = "账户锁定时间")
    private Date lockedTime;

    @ApiModelProperty(value = "账号生效时间")
    private Date enabledTime;

    @ApiModelProperty(value = "账户过期时间")
    private Date expiredTime;

    @ApiModelProperty(value = "盐")
    private String salt;

    @ApiModelProperty(value = "开始时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "性别(‘M’:男,'F':女)")
    private String sex;

    @ApiModelProperty(value = "职位")
    private String position;

    @ApiModelProperty(value = "微信")
    private String wechat;

    @ApiModelProperty(value = "微信图片")
    private String wechatPic;

    @ApiModelProperty(value = "有效天数")
    private Integer validDays;

    @ApiModelProperty(value = "全名")
    private String fullName;

    @ApiModelProperty(value = "工号")
    private String workNum;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "账号描述")
    private String description;

    @ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "部门全名称")
    private String orgFullName;

    @ApiModelProperty(value = "公司名称")
    private String companyName;

    @ApiModelProperty(value = "启禁用日志")
    private List<AccountEnableLog> logs;

    @ApiModelProperty(value = "企业地址")
    private String companyAddress;

    @ApiModelProperty(value = "app注册id")
    private String appRegistrationId;

    @ApiModelProperty(value = "app注册id")
    private Integer companyDefaultAdmin;

    @ApiModelProperty(value = "备注1")
    private String remarkFirst;

    @ApiModelProperty(value = "备注2")
    private String remarkSecond;

    @ApiModelProperty(value = "备注3")
    private String remarkThird;


    private String enabledState;

    private String createTimeStr;

    private String expiredTimeStr;

    private String validDaysStr;

    private String department;

    private String orgCode;

    @ApiModelProperty(value = "经验池可见范围组别")
    private String group;

    @ApiModelProperty(value = "经验池可见范围批次")
    private String batchNo;

    @ApiModelProperty(value = "经验池可见范围备注")
    private String note;
    
    @ApiModelProperty(value = "身份证号")
    private String idNumber;

    @ApiModelProperty(value = "是否开启用户的debug开放者模式")
    private Boolean dev;

    @ApiModelProperty(value = "是否绑定微信，true 绑定，false 未绑定")
    private Boolean bindWeChat;

    @ApiModelProperty(value = "绑定状态")
    private String bindWeChatState;
}
