package com.yizhi.system.application.vo.domain;

import com.yizhi.system.application.vo.AuthzMenuVo2;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 模块
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-05-16
 */
@Data
@Api(tags = "AuthzMenu", description = "菜单")
public class AuthzMenu  {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "对应功能模块code")
    private String code;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "是否不需要权限")
    
    private Boolean ifPublic;

    @ApiModelProperty(value = "父模块id，本身为顶级则为0")
    
    private Long parentId;

    @ApiModelProperty(value = "顶级菜单 id 到该菜单 id 的集合，逗号分隔，顶级菜单为自身 id")
    
    private String parentIdLayer;

    @ApiModelProperty(value = "归属类型：1通用类型：全平台所有站点可见；2企业类型：指定企业内所有站点可见；3站点类型：指定站点内可见。")
    private Integer type;

    @ApiModelProperty(value = "是否是运营菜单")
    
    private Boolean operationMenu;

    @ApiModelProperty(value = "默认站点有效（其他附属站点无效）")
    
    private Boolean defaultSiteOnly;

    @ApiModelProperty(value = "是否可以被资源归属")
    
    private Integer hasResource;

    @ApiModelProperty(value = "前端路由")
    private String url;

    @ApiModelProperty(value = "排序")
    
    private Integer sort;

    @ApiModelProperty(value = "是否启用")
    private Integer enabled;

    @ApiModelProperty(value = "是否删除")
    private Integer deleted;

    @ApiModelProperty(value = "菜单类型 ： 0 目录 1 页面 2 分隔符")
    
    private Integer menuType;

    @ApiModelProperty(value = "所属企业id，type=1或3时为0")
    
    private Long companyId;

    @ApiModelProperty(value = "所属站点id，type=1或2时为0")
    
    private Long siteId;

    @ApiModelProperty(value = "国际化需要的key")
    
    private String internationalKey;

    @ApiModelProperty(value = "创建者id")
    
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    
    private Date updateTime;

    @ApiModelProperty(value = "icon")
    
    private String icon;

    @ApiModelProperty(value = "activeIcon")
    
    private String activeIcon;

    public AuthzMenu(AuthzMenuVo2 authzMenuVo2) {
        this.id = authzMenuVo2.getId();
        this.name = authzMenuVo2.getName();
        this.code = authzMenuVo2.getCode();
        this.description = authzMenuVo2.getDescription();
        this.ifPublic = authzMenuVo2.getIfPublic();
        this.parentId = authzMenuVo2.getParentId();
        this.parentIdLayer = authzMenuVo2.getParentIdLayer();
        this.type = authzMenuVo2.getType();
        this.operationMenu = authzMenuVo2.getOperationMenu();
        this.defaultSiteOnly = authzMenuVo2.getDefaultSiteOnly();
        this.hasResource = authzMenuVo2.getHasResource();
        this.url = authzMenuVo2.getUrl();
        this.sort = authzMenuVo2.getSort();
        this.enabled = authzMenuVo2.getEnabled();
        this.deleted = authzMenuVo2.getDeleted();
        this.menuType = authzMenuVo2.getMenuType();
        this.companyId = authzMenuVo2.getCompanyId();
        this.siteId = authzMenuVo2.getSiteId();
        this.createById = authzMenuVo2.getCreateById();
        this.createByName = authzMenuVo2.getCreateByName();
        this.createTime = authzMenuVo2.getCreateTime();
        this.updateById = authzMenuVo2.getUpdateById();
        this.updateByName = authzMenuVo2.getUpdateByName();
        this.updateTime = authzMenuVo2.getUpdateTime();
        this.icon = authzMenuVo2.getIcon();
        this.activeIcon = authzMenuVo2.getActiveIcon();
    }

    public AuthzMenu() {
    }

   
}

