package com.yizhi.system.application.vo.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 学习组
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-04-16
 */
@Data
@Api(tags = "UserGroup", description = "后台管辖区")
public class AuthzUserGroup  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "管辖区名称")
    private String name;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "所属站点id")
    private Long siteId;

    @ApiModelProperty(value = "所属企业id")
    private Long companyId;

    @ApiModelProperty(value = "是否删除(0:否,1:是)")
    private Boolean deleted;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;
    
    @ApiModelProperty(value = "关联账号数")
    private Integer accountCount;

    @ApiModelProperty(value = "账号id列表")
    private List<Long> accountIds;

    @ApiModelProperty(value = "部门id列表")
    private List<Long> orgIds;



}
