package com.yizhi.system.application.vo.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 企业管理
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "Company", description = "企业管理")
public class Company  implements Serializable{

    private static final long serialVersionUID = 1L;

    /**
     * 授权码,企业直接访问api接口（定制访问）
     */
    @ApiModelProperty(value = "授权码")
    private String authCode;

    @ApiModelProperty(value = "公司id")
	private Long id;

    @ApiModelProperty(value = "企业编码")
	private String code;

    @ApiModelProperty(value = "中文名字")
	private String name;

    @ApiModelProperty(value = "英文名字")
	private String enName;

    @ApiModelProperty(value = "企业logo图标")
	private String logo;

    @ApiModelProperty(value = "企业简介")
	private String context;

    @ApiModelProperty(value = "行业类型1保险2金融3证券4其它")
	private Integer categoryId;

    @ApiModelProperty(value = "企业地址")
    private String address;

    @ApiModelProperty(value = "状态(1:初始化，2：启用，3：停用)")
	private Integer status;

    @ApiModelProperty(value = "到期时间")
	private Date expiredTime;
    
    @ApiModelProperty(value = "企业域名")
    private String domain;

    @ApiModelProperty(value = "创建人id")
	private Long createById;

    @ApiModelProperty(value = "创建人姓名")
	private String createByName;

    @ApiModelProperty(value = "创建时间")
	private Date createTime;

    @ApiModelProperty(value = "更新人id")
	private Long updateById;

    @ApiModelProperty(value = "更新人姓名")
	private String updateByName;

    @ApiModelProperty(value = "更新时间")
	private Date updateTime;
    
    @ApiModelProperty(value = "超级管理员账号")
    private Account superAdmin;
    
    @ApiModelProperty(value = "联系人列表")
    private List<CompanyContactor> contactors;
    
    @ApiModelProperty(value = "关闭账号的人数")
    private Integer memberCloseCount;
    
    @ApiModelProperty(value = "总账号人数")
    private Integer memberCount;
    
    @ApiModelProperty(value = "总部门数")
    private Integer orgCount;



}
