package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 活跃用户比例
 * </p>
 *
 * @author shengchenglong
 * @since 2019-10-09
 */
@Data
@Api(tags = "DaIndicatorAccount", description = "活跃用户比例")
public class DaIndicatorAccount  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "站点总人数")
    private Integer accountTotal;

    @ApiModelProperty(value = "活跃人数（登陆一次就算）")
    private Integer accountActive;

    @ApiModelProperty(value = "活跃用户比例")
    private String accountActivePercentage;

    @ApiModelProperty(value = "周环比（（上周登录人数-上上周登录人数）/上周登录人数×100%）")
    private String weekChain;

    @ApiModelProperty(value = "统计开始天数（一周）")
    private Date startDay;

    @ApiModelProperty(value = "统计结束天数（一周）")
    private Date endDay;

    @ApiModelProperty(value = "处理时间")
    private Date processTime;

    @ApiModelProperty(value = "模块类型（预留）")
    private Integer module;




}
