package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 登陆统计（周）
 * </p>
 *
 * @author shengchenglong
 * @since 2019-10-09
 */
@Data
@Api(tags = "DaIndicatorLoginWeek", description = "登陆统计（周）")
public class DaIndicatorLoginWeek  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "登陆有多少人")
    private Integer personNum;

    @ApiModelProperty(value = "登陆人次")
    private Integer personTime;

    @ApiModelProperty(value = "开始时间（天）")
    private Date startDay;

    @ApiModelProperty(value = "开始时间（天）")
    private Date endDay;

    @ApiModelProperty(value = "处理时间")
    private Date processTime;




}
