package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 项目通过率
 * </p>
 *
 * @author shengchenglong
 * @since 2019-10-09
 */
@Data
@Api(tags = "DaIndicatorTpFinish", description = "项目通过率")
public class DaIndicatorTpFinish  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "本周站点下项目通过数")
    private Integer finishCount;

    @ApiModelProperty(value = "本周站点下项目完成比例")
    private String tpFinishPercentage;

    @ApiModelProperty(value = "周环比（上周项目通过率-上上周项目通过率）/上周项目通过率×100%")
    private String weekChain;

    @ApiModelProperty(value = "统计开始天数（一周）")
    private Date startDay;

    @ApiModelProperty(value = "统计结束天数（一周）")
    private Date endDay;

    @ApiModelProperty(value = "处理时间")
    private Date processTime;




}
