package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 组织部门
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "Organization", description = "组织部门")
public class Organization  {

    private static final long serialVersionUID = 1L;

    public static final String PARENT_ID_LAYER_SEPARATOR = "_";

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "机构代码")
    private String code;

    @ApiModelProperty(value = "机构名称")
    private String name;

    @ApiModelProperty(value = "外文名称")
    private String enName;

    @ApiModelProperty(value = "顶层机构id（当前为顶层则为“0”）")
    private Long rootId;

    @ApiModelProperty(value = "父机构id（当前为顶层则为“0”）")
    private Long parentId;

    @ApiModelProperty(value = "父id层级结构，rootId开始，自身id结尾，下划线分隔")
    private String parentIdLayer;

    @ApiModelProperty(value = "企业id")
    private Long companyId;

    @ApiModelProperty(value = "层级")
    private Integer layer;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "是否删除(0:否,1:是)")
    private Boolean deleted;

    @ApiModelProperty(value = "部门描述")
    private String description;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    private Integer leftIndex;

    private Integer rightIndex;




}
