package com.yizhi.system.application.vo.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 站点
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "Site", description = "站点")
public class Site  {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "站点名称")
    private String name;

    @ApiModelProperty(value = "站点code")
    private String code;

    @ApiModelProperty(value = "域名")
    private String domain;

    @ApiModelProperty(value = "备案")
    private String records;

    @ApiModelProperty(value = "标识")
    private String logo;

    @ApiModelProperty(value = "是否开通：0否，1是；默认1")
    private Boolean enabled;

    @ApiModelProperty(value = "站点类型(1:默认站点，2:业务站点（关联管辖区）)")
    private Integer type;

    @ApiModelProperty(value = "后台管辖区id，默认站点为0")
    private Long userGroupId;

    @ApiModelProperty(value = "公司id")
    private Long companyId;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "是否是运营站点")
    private Boolean operationSite;

    @ApiModelProperty(value = "视频速率 0 为关闭，大于0为速率开启")
    private Integer videoRate;



}
