package com.yizhi.system.application.constant;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashSet;
import java.util.Set;

/**
 * @description: 密码强度校验
 * 1) 密码控制只能输入字母、数字、特殊符号(~!@#$%^&*()_+[]{}|\;:'",./<>?)
 * 2) 长度 8-20 位，必须包括大小写字母、数字、特殊符号中的3种
 * 3) 密码不能包含用户名信息
 * @author: lingye
 * @date 2020-6-16 18:17:24
 **/

public class CheckPassword {
    private static Logger logger = LoggerFactory.getLogger(CheckPassword.class);
    /**
     * 数字
     */
    public static final String REG_NUMBER = ".*\\d+.*";
    /**
     * 小写字母
     */
    public static final String REG_UPPERCASE = ".*[A-Z]+.*";
    /**
     * 大写字母
     */
    public static final String REG_LOWERCASE = ".*[a-z]+.*";
    /**
     * 特殊符号(~!@#$%^&*()_+|<>,.?/:;'[]{}\)
     */
    public static final String REG_SYMBOL = ".*[~!@#$%^&*()_+|<>,.?/:;'\\[\\]{}\\\\\"]+.*";


    public static boolean checkPasswordRule(String password, String username) {

        //密码为空及长度大于8位小于20判断
        if (password == null || password.length() < 8 || password.length() > 20) {
            return false;
        }

        char[] chars = password.toCharArray();
        String tem = null;
        Set numSet = new HashSet(4);
        for (char a : chars) {
            tem = String.valueOf(a);
            if (tem.matches(REG_UPPERCASE)) {
                numSet.add(1);
                continue;
            }
            if (tem.matches(REG_LOWERCASE)) {
                numSet.add(2);
                continue;
            }
            if (tem.matches(REG_NUMBER)) {
                numSet.add(3);
                continue;
            }
            if (tem.matches(REG_SYMBOL)) {
                numSet.add(4);
            } else {
                logger.error("存在不合法的特殊字符:" + a);
                return false;
            }
        }
        boolean contains = password.contains(username);
        if (numSet.size() < 3 || contains) {
            return false;
        }

        return true;
    }

//    public static void main(String[] args) {
//
//        String s = SM2_NEW.decryptWithSalt("049737f9d8fcbb0c7a92ee8539363e992d45be2c66f6718f14c434b507768e27890bc8fdd104b474d33199a5828d7aba0d7ab931f46225c566e2a7dab48997b1b67edbe6aeee6d4bd50f48de99479a9bcd2c9d82b1b6c5193668efc58f89c01b2eec43c9fc7b0610f0953d3e78c6a15324dccf6a6210");
//        System.out.println("s=   " + s);
//        boolean flag = checkPasswordRule("wenbsu", "478");
//        System.out.println(flag);
//
//    }


    public static boolean checkPasswordRule(String password) {

        //密码为空及长度大于8位小于20位判断
        if (password == null || password.length() < 8 || password.length() > 20) {
            return false;
        }

        int i = 0;

        if (password.matches(CheckPassword.REG_NUMBER)) {
            i++;
        }
        if (password.matches(CheckPassword.REG_LOWERCASE)) {
            i++;
        }
        if (password.matches(CheckPassword.REG_UPPERCASE)) {
            i++;
        }
        if (password.matches(CheckPassword.REG_SYMBOL)) {
            i++;
        }
        System.out.println(i);
        if (i < 3) {
            return false;
        }

        return true;
    }
}