package com.yizhi.system.application.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.SmsSendBizType;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.system.application.constant.CheckPassword;
import com.yizhi.system.application.enums.SecurityReturnCode;
import com.yizhi.system.application.exception.AuthNoManagementException;
import com.yizhi.system.application.exception.AuthNotManageException;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.service.ISensitiveWordService;
import com.yizhi.system.application.service.IStudentEditPermissionService;
import com.yizhi.system.application.util.SignUtil;
import com.yizhi.system.application.vo.*;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.BizResponse;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.httpclient.HttpClientUtils;
import com.yizhi.util.application.sensitive.SensitiveWordInit;
import com.yizhi.util.application.sensitive.SensitivewordFilter;
import com.yizhi.util.application.sm2.SM2_NEW;
import com.yizhi.wechat.application.feign.WeiXinClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

import static com.yizhi.system.application.constant.CommunityParams.*;
import static com.yizhi.util.application.enums.i18n.Constants.SYSTEM_MSG_COMPANY_NOT_EXIST;

@Api(tags = "账号Api接口")
@RestController
@RequestMapping(value = "/api/account")
public class AccountApi {

    @Autowired
    IAccountService accountService;
    @Autowired
    DomainConverter converter;
    @Autowired
    TaskExecutor executor;
    @Autowired
    LogEventPublisher eventPublisher;
    @Autowired
    ISensitiveWordService sensitiveWordService;
    @Autowired
    ICompanyService companyService;
    @Autowired
    IStudentEditPermissionService studentEditPermissionService;
    @Autowired
    WeiXinClient weiXinClient;
    @Autowired
    RedisCache redisCache;
    @Value("${community.get.token.location}")
    private String LOCATION;
    private static final Logger logger = LoggerFactory.getLogger(AccountApi.class);

    @ApiOperation(value = "移动端密码修改", notes = "app和学员端密码修改接口（只更新密码）")
    @PostMapping(value = "/mobile/pwd/update")
    public Response<String> mobilePwdUpdate(@RequestBody MbAccountPwdUpVO vo){
        RequestContext rt = ContextHolder.get();

        Long accountId = rt.getAccountId();

        com.yizhi.system.application.domain.Account account = this.accountService.selectById(accountId);
        if(account==null){
            return Response.fail("用户不存在");
        }

        Long companyId = rt.getCompanyId();
        if(!account.getCompanyId().equals(companyId)){
            return Response.fail("无权限修改用户信息");
        }
        if(StringUtils.isBlank(vo.getPassword())){
            return Response.fail("密码不能为空");
        }
        
        String newPassword = vo.getPassword();
        String confirmPassword = vo.getConfirmPassword();
        String salt = vo.getSalt();

        SortedMap<String, String> sugMap = new TreeMap<String, String>();
        sugMap.put("sign", vo.getSign());
        sugMap.put("password", newPassword);
        sugMap.put("confirmPassword", confirmPassword);
        sugMap.put("salt", salt);
        boolean correctSign = SignUtil.isCorrectSign(sugMap, vo.getSalt());
        if (!correctSign) {
            //临时注释
//            return Response.fail(ReturnCode.SIGN_FAIL.getCode(), ReturnCode.SIGN_FAIL.getMsg());
        }
        String sign = (String) redisCache.get(vo.getSign());
        if (StringUtils.isNotBlank(sign)) {
        	return Response.fail(ReturnCode.DUPLICATE_REQUEST.getCode(),ReturnCode.DUPLICATE_REQUEST.getMsg());
		}else {
			redisCache.set(vo.getSign(), "1", 86400);
		}
        // 解密
        String decryptNewPwd = null;
        String decryptConfirmPassword = null;
        try {
            decryptNewPwd = SM2_NEW.decryptWithSalt(newPassword);
            decryptConfirmPassword = SM2_NEW.decryptWithSalt(confirmPassword);
            logger.info("新密码：{}；确认密码：{}", decryptNewPwd, decryptConfirmPassword);

        } catch (Exception e) {
            e.printStackTrace();
        }
      

        if (!decryptNewPwd.equals(decryptConfirmPassword)) {
            return Response.fail(Constants.SYSTEM_MSG_CONFIRM_PWD_NOT_CORRECT.getCode().toString(), Constants.SYSTEM_MSG_CONFIRM_PWD_NOT_CORRECT.getName());
        }
        
        //修改密码
        if (StringUtils.isNotBlank(newPassword)) {
            try {
                    // 新密码规则
                    if (!CheckPassword.checkPasswordRule(decryptNewPwd, account.getName())) {
                        return Response.fail(Constants.NON_COMPLIANT_PASSWORD.getCode().toString(), Constants.NON_COMPLIANT_PASSWORD.getName());
                    }

                com.yizhi.system.application.domain.Account saveAccount = new com.yizhi.system.application.domain.Account();
                    saveAccount.setId(accountId);

                    String md5Pwd = ShaEncrypt.encryptNewPassword(decryptNewPwd);
                    saveAccount.setPassword(md5Pwd);
                    saveAccount.setFirstLogin(Boolean.FALSE);
                    saveAccount.setUpdateById(rt.getAccountId());
                    saveAccount.setUpdateByName(rt.getAccountName());
                    saveAccount.setUpdateTime(new Date());
                    accountService.updateById(saveAccount);
                    return Response.ok(Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getCode().toString(), Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getName());
            } catch (Exception e) {
                e.printStackTrace();
            }

        } else {
            return Response.fail(Constants.SYSTEM_MSG_PWD_EMPTY.getCode().toString(), Constants.SYSTEM_MSG_PWD_EMPTY.getName());
        }
//        Account accountUp = new Account();
//        accountUp.setId(accountId);
//        accountUp.setFirstLogin(false);
//        accountUp.setPassword(ShaEncrypt.encryptNewPassword(vo.getPassword()));
//        accountUp.setUpdateById(rt.getAccountId());
//        accountUp.setUpdateByName(rt.getAccountName());
//        accountUp.setUpdateTime(new Date());
//        this.accountService.update(accountUp);
        return Response.ok(Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getCode().toString(),Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getName());
    }
    /**
     * 校验参数 https://blog.csdn.net/mytt_10566/article/details/80844202 https://www.baeldung.com/javax-validation
     * https://blog.csdn.net/qq_37142346/article/details/79875059
     * @param accountPwdUpVO
     * @return
     */
    @ApiOperation(value = "忘记密码", notes = "通过手机号和密码更新账号信息")
    @PostMapping(value = "/public/forget/pwd/update")
    public Response<String> forgetPwdUpdate(@RequestBody AccountPwdUpVO accountPwdUpVO) {
        String newPassword = accountPwdUpVO.getPassword();
        String confirmPassword = accountPwdUpVO.getConfirmPassword();
        String salt = accountPwdUpVO.getSalt();
        String smsSendRequestNo = accountPwdUpVO.getSmsSendRequestNo();
        if (StringUtils.isBlank(smsSendRequestNo)) {
            logger.error("忘记密码功能，缺失必要参数！！！");
            return Response.fail(Constants.SYSTEM_MSG_EXTENT_EMPTY.getCode().toString()
                    , Constants.SYSTEM_MSG_EXTENT_EMPTY.getName());
        }

        SortedMap<String, String> sugMap = new TreeMap<String, String>();
        sugMap.put("sign", accountPwdUpVO.getSign());
        sugMap.put("password", newPassword);
        sugMap.put("confirmPassword", confirmPassword);
        sugMap.put("salt", salt);
        boolean correctSign = SignUtil.isCorrectSign(sugMap, salt);
        if (!correctSign) {
            //临时注释
//            return Response.fail(ReturnCode.SIGN_FAIL.getCode(), ReturnCode.SIGN_FAIL.getMsg());
        }
        String sign = (String) redisCache.get(accountPwdUpVO.getSign());
        if (StringUtils.isNotBlank(sign)) {
        	return Response.fail(ReturnCode.DUPLICATE_REQUEST.getCode(),ReturnCode.DUPLICATE_REQUEST.getMsg());
		}else {
			redisCache.set(accountPwdUpVO.getSign(), "1", 86400);
		}
        // 解密
        String decryptNewPwd = null;
        String decryptConfirmPassword = null;
        try {
            decryptNewPwd = SM2_NEW.decryptWithSalt(newPassword);
            decryptConfirmPassword = SM2_NEW.decryptWithSalt(confirmPassword);
            logger.info("新密码：{}；确认密码：{}", decryptNewPwd, decryptConfirmPassword);
            accountPwdUpVO.setPassword(decryptNewPwd);
            accountPwdUpVO.setConfirmPassword(decryptConfirmPassword);
        } catch (Exception e) {
            e.printStackTrace();
        }
        com.yizhi.system.application.domain.Account account = null;
        try {
            FirstLoginUpdateVO loginUpdateVO = new FirstLoginUpdateVO();
            BeanUtils.copyProperties(accountPwdUpVO,loginUpdateVO);
            account = accountService.checkUpPwdData(loginUpdateVO, SmsSendBizType.FORGET_PWD,smsSendRequestNo);
        } catch (BizException e) {
            return Response.fail(e.getCode(),e.getMsg());
        }
        com.yizhi.system.application.domain.Account accountUp = new com.yizhi.system.application.domain.Account();
        accountUp.setId(account.getId());
        accountUp.setPassword(ShaEncrypt.encryptNewPassword(accountPwdUpVO.getPassword()));
        accountUp.setFirstLogin(false);
        accountUp.setFirstLoginTime(new Date());
        accountService.update(accountUp);
		return Response.ok(Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getCode().toString(),Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getName());
    }

    @ApiOperation(value = "账户修改", notes = "用户首次登陆，提示用户修改密码")
    @PostMapping(value = "/public/first/login/update")
    public Response<String> firstLoginUpdate(@RequestBody FirstLoginUpdateVO loginUpdateVO) {
        String newPassword = loginUpdateVO.getPassword();
        String confirmPassword = loginUpdateVO.getConfirmPassword();
        String salt = loginUpdateVO.getSalt();
        String smsSendRequestNo = loginUpdateVO.getSmsSendRequestNo();
        if (StringUtils.isBlank(smsSendRequestNo)) {
            logger.error("用户首次登陆修改密码功能，缺失必要参数！！！");
            return Response.fail(Constants.SYSTEM_MSG_EXTENT_EMPTY.getCode().toString()
                    , Constants.SYSTEM_MSG_EXTENT_EMPTY.getName());
        }
        SortedMap<String, String> sugMap = new TreeMap<String, String>();
        sugMap.put("sign", loginUpdateVO.getSign());
        sugMap.put("password", newPassword);
        sugMap.put("confirmPassword", confirmPassword);
        sugMap.put("salt", salt);
        boolean correctSign = SignUtil.isCorrectSign(sugMap, salt);
        if (!correctSign) {
            //临时注释
//            return Response.fail(ReturnCode.SIGN_FAIL.getCode(), ReturnCode.SIGN_FAIL.getMsg());
        }
        String sign = (String) redisCache.get(loginUpdateVO.getSign());
        if (StringUtils.isNotBlank(sign)) {
        	return Response.fail(ReturnCode.DUPLICATE_REQUEST.getCode(),ReturnCode.DUPLICATE_REQUEST.getMsg());
		}else {
			redisCache.set(loginUpdateVO.getSign(), "1", 86400);
		}
        // 解密
        String decryptNewPwd = null;
        String decryptConfirmPassword = null;
        try {
            decryptNewPwd = SM2_NEW.decryptWithSalt(newPassword);
            decryptConfirmPassword = SM2_NEW.decryptWithSalt(confirmPassword);
            logger.info("新密码：{}；确认密码：{}", decryptNewPwd, decryptConfirmPassword);
            loginUpdateVO.setPassword(decryptNewPwd);
            loginUpdateVO.setConfirmPassword(decryptConfirmPassword);
        } catch (Exception e) {
            e.printStackTrace();
        }
        com.yizhi.system.application.domain.Account account = null;
        try {
            account = accountService.checkUpPwdData(loginUpdateVO, SmsSendBizType.FIRST_LOGIN,smsSendRequestNo);
        } catch (BizException e) {
            return Response.fail(e.getCode(),e.getMsg());
        }
        com.yizhi.system.application.domain.Account accountUp = new com.yizhi.system.application.domain.Account();
        accountUp.setId(account.getId());
        accountUp.setMobile(loginUpdateVO.getMobile().toString());
        accountUp.setPassword(ShaEncrypt.encryptNewPassword(loginUpdateVO.getPassword()));
        accountUp.setFirstLogin(false);
        accountUp.setFirstLoginTime(new Date());
        accountService.update(accountUp);
		return Response.ok(Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getCode().toString(),Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getName());
    }
    /**
     * 更新账号密码
     * @param authVO
     * @return
     */
    @ApiOperation(value = "账号", notes = "修改密码")
    @PostMapping(value = "/update/password")
    public Response<String> updatePassword(@RequestBody AccountRegisterVO authVO) {
        try {
            com.yizhi.system.application.domain.Account account = accountService.selectById(ContextHolder.get().getAccountId());
            if (account == null) {
                return Response.fail(ReturnCode.ACCOUNT_NOT_EXIST.getCode(), ReturnCode.ACCOUNT_NOT_EXIST.getMsg());
            }
            if (StringUtils.isNotBlank(authVO.getPassword())) {
                // 新密码规则
                if (!CheckPassword.checkPasswordRule(authVO.getPassword(), account.getName())) {
                    return Response.fail(Constants.NON_COMPLIANT_PASSWORD.getCode().toString(), Constants.NON_COMPLIANT_PASSWORD.getName());
                }
                accountService.updatePassword(ContextHolder.get().getAccountId(), authVO.getPassword());
            } else {
                Response.fail("密码不能为空！！！");
            }

        }catch (BizException be) {
            return Response.fail(be.getCode(),be.getMsg());
        }catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return  Response.ok();
    }

    /**
     * 更新账号
     *
     * @param accountVO
     * @return
     */
    @ApiOperation(value = "账号", notes = "修改账号")
    @PostMapping(value = "/update")
    public Response<String> updateAccount(@RequestBody AccountVO accountVO) {
        try {
            Long accountId= ContextHolder.get().getAccountId();
            Long companId = ContextHolder.get().getCompanyId();
            String description = accountVO.getDescription();
            if(StringUtils.isNotBlank(description)){
                // 敏感词校验
                com.yizhi.system.application.domain.SensitiveWord sw = new com.yizhi.system.application.domain.SensitiveWord();
                sw.setCompanyId(companId);
                List<com.yizhi.system.application.domain.SensitiveWord> swList = sensitiveWordService.selectList(QueryUtil.condition(sw));
                if(CollectionUtils.isNotEmpty(swList)){
                    Set<String> sensitiveWord = swList.stream().map(obj->obj.getName()).collect(Collectors.toSet());
                    logger.info("敏感词信息={}",sensitiveWord);
                    // 初始化敏感词
                    Map<String,Object> sensitiveWordMap = SensitiveWordInit.addSensitiveWordToHashMap(sensitiveWord);
                    for(int i = 0 ; i < description.length() ; i++){
                        //判断是否包含敏感字符；  matchType = 1 最小匹配，
                        //最小匹配规则，如：敏感词库["中国","中国人"]，语句："我是中国人"，匹配结果：我是[中国]人
                        //最大匹配规则，如：敏感词库["中国","中国人"]，语句："我是中国人"，匹配结果：我是[中国人]
                        int matchType = 1;
                        boolean extis = SensitivewordFilter.contains(sensitiveWordMap, description, matchType);
                        //存在,加入list中
                        if(extis){
                            String wordFilter = SensitivewordFilter.sensitiveFilter(description,sensitiveWord);
                            if(wordFilter.indexOf(SensitivewordFilter.DEFAULT_REPLACE_CHAR)>=0){
                                // 存在敏感词
                                return Response.fail(SecurityReturnCode.SENSITIVEWORD_ERROR.getSubcode(),wordFilter);
                            }
                        }
                    }

                }
            }
            accountVO.setId(accountId);
            accountService.update((com.yizhi.system.application.domain.Account)converter.toDO(accountVO, com.yizhi.system.application.domain.Account.class));
        }catch (BizException be) {
            return Response.fail(be.getCode(),be.getMsg());
        }catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 根据账号id查询账号信息
     * @return
     */
    @ApiOperation(value = "账号", notes = "获取")
    @GetMapping(value = "/get")
    public Response<AccountVO> findById() {
        RequestContext rc = ContextHolder.get();
        try {
            AccountVO accountVO=(AccountVO)converter.toVO(accountService.get(rc.getAccountId()), AccountVO.class);
            StudentEditPermissionVO vo = null;
            com.yizhi.system.application.domain.StudentEditPermission ew = new com.yizhi.system.application.domain.StudentEditPermission();
            ew.setSiteId(rc.getSiteId());
            com.yizhi.system.application.domain.StudentEditPermission obj = studentEditPermissionService.selectOne(QueryUtil.condition(ew));
            if(obj != null){
                vo = new StudentEditPermissionVO();
                BeanUtils.copyProperties(obj,vo);
            }
            accountVO.setEditPermissionVO(vo);
            return Response.ok(accountVO);
        }catch (BizException be) {
            return Response.fail(be.getCode(),be.getMsg());
        }catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 查找当前用户所属的组织
     * @return
     */
    @ApiOperation(value = "查询用户当前组织的子部门和组织用户", notes = "查询用户当前组织的子部门和组织用户")
    @RequestMapping(value = "/org/member", method = RequestMethod.GET)
    public Response<List<OrgAccountVO>> getAccountOrgs(@ApiParam(required = false, value = "要查询的组织id，不传查询当前用户组织下的用户和第一级所属组织")
                                                       @RequestParam(required = false) String orgId,
                                                       @ApiParam(required = false, value = "查询组织下的第一级子组织和当前组织下的用户")
                                                       @RequestParam(required = false) String queryStr){
        Long selectOrgId = ContextHolder.get().getOrgId();
        if(!StringUtils.trimToEmpty(orgId).equals(StringUtils.EMPTY)){
            selectOrgId = Long.valueOf(orgId);
        }
        List<OrgAccountVO> retLst =  accountService.selectOrgAndAccount(ContextHolder.get().getCompanyId(),
                selectOrgId,ContextHolder.get().getSiteId(),queryStr,1);
        return Response.ok(retLst);
    }

    /**
     * 查找当前用户组织下面的人
     * @return
     */
    @ApiOperation(value = "查询用户当前组织的子部门和组织用户", notes = "查询用户当前组织的子部门和组织用户")
    @RequestMapping(value = "/user/member", method = RequestMethod.GET)
    public Response<List<OrgAccountVO>> getAccountMember(
            @ApiParam(required = false, value = "查询组织下的第一级子组织和当前组织下的用户")
            @RequestParam(required = false) String queryStr){
        Long selectOrgId = ContextHolder.get().getOrgId();
/*		if(!StringUtils.trimToEmpty(orgId).equals(StringUtils.EMPTY)){
			selectOrgId = Long.valueOf(orgId);
		}*/
        List<OrgAccountVO> retLst =  accountService.selectOrgAndAccount(ContextHolder.get().getCompanyId(),
                selectOrgId,ContextHolder.get().getSiteId(),queryStr,2);
        return Response.ok(retLst);
    }

    /**
     * 查找当前用户的用户组
     * @return
     */
    @ApiOperation(value = "查询用户组信息", notes = "查询用户组信息")
    @RequestMapping(value = "/usergroup/member", method = RequestMethod.GET)
    public Response<String> getAccountUsergroup(@ApiParam(required = false, value = "查询关键字段，不传就按默认查询")
                                                @RequestParam(required = false) String queryStr){
        List<OrgAccountVO> retLst =  accountService.selectOrgAndAccount(ContextHolder.get().getCompanyId(),
                ContextHolder.get().getOrgId(),ContextHolder.get().getSiteId(),queryStr,3);
        return Response.ok(retLst);
    }

    /**
     * 根据账号id查询账号信息
     * @param accountId
     * @return
     */
    @ApiOperation(value = "获取账号名片信息", notes = "获取账号名片信息", response = AccountVO.class)
    @GetMapping(value = "/card/get")
    public Response<AccountVO> findCardById(@ApiParam(value = "用户id")
                                            @RequestParam(value="accountId") long accountId) {
        try {
            AccountVO accountVO=(AccountVO)converter.toVO(accountService.getCard(accountId), AccountVO.class);
            return Response.ok(accountVO);
        }catch (BizException be) {
            return Response.fail(be.getCode(),be.getMsg());
        }catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "新增appId", notes = "新增appId")
    @PostMapping(value = "/appid/add")
    public Response<String> addAppId(@RequestBody AccountAppInfoVO infoVO) {
        try {
            com.yizhi.system.application.domain.Account account=new com.yizhi.system.application.domain.Account();
            account.setId(ContextHolder.get().getAccountId());
            account.setAppRegistrationId(infoVO.getAppId());
            accountService.updateRegistrationId(account);
        }catch (BizException be) {
            return Response.fail(be.getCode(),be.getMsg());
        }catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }


    /**
     *
     * @param accountPhoneVO
     * @return
     */
    @ApiOperation(value = "对图形验证码及短信验证码进行验证")
    @PostMapping("/pc/verify")
    public Response Verify(@ApiParam(value ="captchaKey &captchaVal &mobile &smsCode 必传" )@RequestBody AccountPhoneVO accountPhoneVO) {

        try {
            boolean flag = accountService.validateCaptcha(accountPhoneVO.getCaptchaKey(), accountPhoneVO.getCaptchaVal());                                              //图形码验证
            accountService.VerifyCode(SmsSendBizType.UPDATE_MOBILE, accountPhoneVO.getMobile(), accountPhoneVO.getSmsCode());        //短信码验证
            com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();                 //手机号直接在这里进行修改
            account.setMobile(accountPhoneVO.getMobile());
            if (accountPhoneVO.getAccountId()!=null){
                account.setId(accountPhoneVO.getAccountId());
                accountService.updateById(account);
            }
        } catch (BizException e) {
            if (com.yizhi.util.application.enums.i18n.Constants.SYSTEM_MSG_IMG_VERIFY_CODE_EXPIRED.getCode().toString().equals(e.getCode())) {        //图片验证码过期
                return Response.fail(e.getCode(),e.getMsg());
            }
            if (com.yizhi.util.application.enums.i18n.Constants.SYSTEM_MSG_IMG_VERIFY_CODE_NOT_CORRECT.getCode().toString().equals(e.getCode())) {    //图片验证码不正确
                return Response.fail(e.getCode(),e.getMsg());
            }
            if (com.yizhi.util.application.enums.i18n.Constants.SYSTEM_MSG_CODE_EMPTY.getCode().toString().equals(e.getCode())){                        //验证码为空
                return Response.fail(e.getCode(),e.getMsg());
            }
            if (com.yizhi.util.application.enums.i18n.Constants.SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED.getCode().toString().equals(e.getCode())) {        //手机验证码过期
                return Response.fail(e.getCode(),e.getMsg());
            }
            if (Constants.SYSTEM_MSG_SMS_VERIFY_CODE_ERROR.getCode().toString().equals(e.getCode())) {          //手机验证码错误
                return Response.fail(e.getCode(),e.getMsg());
            }
        }
        return Response.ok();

    }

    @ApiOperation(value = "保存用户修改的个人信息")
    @PostMapping("/pc/updateInfo")
    public Response<AccountVO> update(@ApiParam(name = "accountVO", value = "参数形如：{\"id\":1314,\"fullName\":\"taoge\",\"position\":\"业务专员1122\",\"mobile\":\"12345678901\",\"description\":\"hutao测\"}")@RequestBody AccountVO accountVO) {

        try {
            com.yizhi.system.application.domain.Company company = new com.yizhi.system.application.domain.Company();
            List<com.yizhi.system.application.domain.Company> companies = new ArrayList<>();
            if (org.apache.commons.lang.StringUtils.isNotBlank(accountVO.getCompanyName())) {
                company.setName(accountVO.getCompanyName());
                EntityWrapper<com.yizhi.system.application.domain.Company> entityWrapper = new EntityWrapper(company);
                companies = companyService.selectList(entityWrapper);
                if (companies != null && companies.size() > 0) {
                    company = companies.get(0);
                    accountVO.setCompanyId(company.getId());
                } else {
                    throw new BizException(SYSTEM_MSG_COMPANY_NOT_EXIST.getCode().toString(), SYSTEM_MSG_COMPANY_NOT_EXIST.getName());
                }
            }

            boolean flag = accountService.updateInfo((com.yizhi.system.application.domain.Account) converter.toDO(accountVO, com.yizhi.system.application.domain.Account.class));

        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
        return Response.ok();
    }

    /**
     * 学员端更新账号密码
     *
     * @return
     */
    @ApiOperation(value = "账号", notes = "学院端修改密码")
    @PostMapping(value = "/api/update/password")
    public Response<String> updateApiPassword(@ApiParam (name = "map", value = "传学员ID、修改后的密码", required = true) @RequestBody Map map) {
        try {

//            Long id = new Long(map.get("id").toString());
            String oldPassword = map.get("oldPassword").toString();
            String newPassword = map.get("newPassword").toString();
            String sign = map.get("sign").toString();
            String salt = map.get("salt").toString();
            logger.info("传参：{}", JSON.toJSON(map));

            SortedMap<String, String> sugMap = new TreeMap<String, String>();
            sugMap.put("sign", sign);
            sugMap.put("oldPassword", oldPassword);
            sugMap.put("newPassword", newPassword);
            sugMap.put("salt", salt);
            logger.info("加密内容：{}", JSON.toJSON(sugMap));

            
            RequestContext context = ContextHolder.get();
            com.yizhi.system.application.domain.Account account = this.accountService.selectById(context.getAccountId());

            boolean correctSign = SignUtil.isCorrectSign(sugMap, salt);
            if (!correctSign) {
                //临时注释
//                return Response.fail(ReturnCode.SIGN_FAIL.getCode(), ReturnCode.SIGN_FAIL.getMsg());
            }
            String sign1 = (String) redisCache.get(sign);
            if (StringUtils.isNotBlank(sign1)) {
            	return Response.fail(ReturnCode.DUPLICATE_REQUEST.getCode(),ReturnCode.DUPLICATE_REQUEST.getMsg());
    		}else {
    			redisCache.set(sign, "1", 86400);
    		}
//            boolean b = accountPwdHistoryService.updatedPwdTimes(id, null);
//            //次数用完
//            if (!b) {
//                return Response.fail(ReturnCode.NO_UPDATE_PWD_TIMES.getCode(), ReturnCode.NO_UPDATE_PWD_TIMES.getMsg());
//            }

            // 解密
            String decryptOldPwd = null;
            String decryptNewPwd = null;
            try {
                decryptNewPwd = SM2_NEW.decryptWithSalt(newPassword);
                decryptOldPwd = SM2_NEW.decryptWithSalt(oldPassword);
                logger.info("新密码：{}；旧密码：{}", decryptNewPwd, decryptOldPwd);

            } catch (Exception e) {
                e.printStackTrace();
            }

            if (decryptNewPwd.equals(decryptOldPwd)) {
                return Response.fail(Constants.SYSTEM_MSG_PWD_EXITS.getCode().toString(), Constants.SYSTEM_MSG_PWD_EXITS.getName());
            }

            if (StringUtils.isNotBlank(oldPassword) && StringUtils.isNotBlank(newPassword)) {
                String accountPwd = account.getPassword();
                if (ShaEncrypt.comparePassword(decryptOldPwd, accountPwd)) {
                    // 新密码规则
                    if (!CheckPassword.checkPasswordRule(decryptNewPwd, account.getName())) {
                        return Response.fail(Constants.NON_COMPLIANT_PASSWORD.getCode().toString(),Constants.NON_COMPLIANT_PASSWORD.getName());
                    }

                    com.yizhi.system.application.domain.Account saveAccount = new com.yizhi.system.application.domain.Account();
                    saveAccount.setId(account.getId());
                    String md5Pwd = ShaEncrypt.encryptNewPassword(decryptNewPwd);
                    saveAccount.setPassword(md5Pwd);
                    saveAccount.setFirstLogin(Boolean.FALSE);
                    accountService.updateById(saveAccount);
                    return Response.ok(Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getCode().toString(), Constants.SYSTEM_MSG_PWD_CHANGE_SUCCESS.getName());
                } else {
                    return Response.fail(Constants.SYSTEM_MSG_OLD_PWD_ERROR.getCode().toString(), Constants.SYSTEM_MSG_OLD_PWD_ERROR.getName());
                }
            } else {
                return Response.fail(Constants.SYSTEM_MSG_PWD_EMPTY.getCode().toString(), Constants.SYSTEM_MSG_PWD_EMPTY.getName());
            }
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(Constants.MSG_BIZ_FAIL);
        }
    }
    @ApiOperation(value = "获取访问社群的accessToken")
    @GetMapping("/access/community")
    public BizResponse list() throws AuthNotManageException, AuthNoManagementException {
        RequestContext context = ContextHolder.get();
        com.yizhi.system.application.domain.Account account = accountService.selectById(context.getAccountId());
        String getTokenUrl = new StringBuffer(LOCATION).
                append(GET_TOKEN_URL).append(SYMBOL_1)
                .append(USERNAME).append(SYMBOL_2).append(context.getAccountName()).append(SYMBOL_3)
                .append(PASSWORD).append(SYMBOL_2).append(URLEncoder.encode(account.getPassword())).append(SYMBOL_3)
                .append(GRANT_TYPE).append(SYMBOL_2).append(PASSWORD).append(SYMBOL_3)
                .append(COMPANY_CODE).append(SYMBOL_2).append(context.getCompanyCode()).append(SYMBOL_3)
                .append(SITE_CODE).append(SYMBOL_2).append(context.getSiteCode()).toString();
        Map<String, String> headers = new HashMap<>();
        headers.put(AUTHORIZATION,CLIENT_WEIXIN );
        headers.put(WMY_TOKEN_HEADER, JSON.toJSONString(context));
        logger.info("发送的url；" + getTokenUrl);

        JSONObject jsonObject = null;
        try {
            jsonObject = HttpClientUtils.httpPost(getTokenUrl, null, headers);
        } catch (Exception e) {
            return BizResponse.fail("获取access_token 失败，{}",e.getMessage());
        }
        if (Objects.isNull(jsonObject)) {
            return BizResponse.fail("获取access_token 失败！！！");
        }
        Object o = jsonObject.get(ACCESS_TOKEN);
        if (!Objects.isNull(o)) {
            return BizResponse.ok(o);
        } else {
            return BizResponse.fail("获取access_token 失败！！！");
        }
    }

//    @ApiOperation(value = "根据微信openId获取个人信息")
//    @GetMapping("/public/getAccountByOpenId")
//    public Response<WechatAccountVO> getAccountByOpenId(@ApiParam(name = "openId") @RequestParam(name = "openId")String openId) {
//        WechatAccountVO accountVO = weiXinClient.getAccountByWechatUserId(openId);
//        if (accountVO.getAccountId()!=null) {
//            Account account = accountService.selectById(accountVO.getAccountId());
//            if (account!=null) {
//                accountVO.setFullName(account.getFullName());
//                accountVO.setWorkNum(account.getWorkNum());
//                return Response.ok(accountVO);
//            }else {
//                return Response.fail("用户不存在");
//            }
//        }else {
//            return Response.fail("用户不存在");
//        }
//    }
}
