package com.yizhi.system.application.controller.api;

import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.service.ISiteService;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 10:18 2018/4/4
 * @Modified By
 */
@Api(tags = "企业接口")
@RestController
@RequestMapping(value = "/api/company")
public class CompanyApi {

    @Autowired
    ICompanyService companyService;

    @Autowired
    ISiteService siteService;

    @ApiOperation(value = "根据企业名称查询", notes = "根据企业名称查询")
    @GetMapping(value = "/public/getCompanyByName")
    public Response<String> getCompanyByName(@ApiParam(required = true, value = "企业名称") @RequestParam String companyName){
        Map<String,Object> retMap = new HashMap<>();
        com.yizhi.system.application.domain.Company company = new com.yizhi.system.application.domain.Company();
        company.setName(companyName);
        com.yizhi.system.application.domain.Company retCompany =companyService.selectOne(QueryUtil.condition(company));
        String companyCode = "";
        if(retCompany != null){
            companyCode = retCompany.getCode();
            retMap.put("companyId",retCompany.getId());
        }
        retMap.put("companyCode",companyCode);
        return Response.ok(retMap);
    }

    @ApiOperation(value = "获取企业logo", notes = "获取企业logo")
    @GetMapping(value = "/public/getCompanyLogo")
    public Response<String> getCompanyLogo(){
        Map<String,Object> retMap = new HashMap<>();
        RequestContext rc = ContextHolder.get();
        com.yizhi.system.application.domain.Company cy = new com.yizhi.system.application.domain.Company();
        cy.setCode(rc.getCompanyCode());
        com.yizhi.system.application.domain.Company retCompany =companyService.selectOne(QueryUtil.condition(cy));
        String companyLogo = "";
        if(retCompany != null){
            companyLogo = retCompany.getLogo();
        }
        retMap.put("companyLogo",companyLogo);

        // 获取站点log
        String siteLogo = "";
        Long siteId = rc.getSiteId();
        if(Objects.nonNull(siteId)){
            Site site = siteService.selectById(siteId);
            if(site != null){
                siteLogo = site.getLogo();
            }
        }

        retMap.put("siteLogo",siteLogo);
        return Response.ok(retMap);
    }
}
