package com.yizhi.system.application.controller.api;

import com.yizhi.system.application.service.IFirstLoginLogService;
import com.yizhi.util.application.domain.BizResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "学员端首次登陆判断")
@Slf4j
@RestController
@RequestMapping(value = "/api/firstLogin/")
public class FirstLoginController {

    @Autowired
    private IFirstLoginLogService firstLoginLogService;


    /**
     * 任务1484暂时为只记录光大站点首次登录首页弹框
     *
     * @return
     */
    @GetMapping("judgeIsFirstLogin")
    public BizResponse judgeIsFirstLogin(@ApiParam("终端类型:pc 、h5") @RequestParam("terminalType") String terminalType,
                                         @ApiParam("登陆类型：sms_login、password_login、weChat_login") @RequestParam(value = "loginType", required = false) String loginType) {
        //前端判断规则：  若返回数据为true才弹框
        return BizResponse.ok(firstLoginLogService.saveFirstLoginLog(terminalType, loginType));
    }
}
