package com.yizhi.system.application.controller.api;


import com.yizhi.application.orm.id.IdGenerator;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * <p>
 * 模块 前端控制器
 * </p>
 *
 * @author
 * @since
 */
@Api(tags = "只为了获取id")
@RestController
@RequestMapping("/authz")
public class GetIdController {

    private static final Logger LOGGER = LoggerFactory.getLogger(GetIdController.class);

    @Autowired
    private IdGenerator idGenerator;

    @ApiOperation(value = "获取主键", response = Long.class)
    @GetMapping("/get/id")
    public Long getId() {
        Long id = 0L;
        try {
            id = idGenerator.generate();
        } catch (Exception e) {
            e.printStackTrace();
            LOGGER.info("菜单权限管理，获取id异常");
        }
        return id;
    }
}


