package com.yizhi.system.application.controller.api;


import com.yizhi.system.application.enums.LanguageType;
import com.yizhi.system.application.service.IInternationalizationService;
import com.yizhi.system.application.service.IInternationalizationWordService;
import com.yizhi.util.application.domain.Response;
import com.yizhi.system.application.vo.LanguageTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 前端控制器
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@Api(tags = "国际化接口")
@RestController
@RequestMapping("/api/internationalizationWord")
public class InternationalizationWordApiController {

    @Autowired
    private IInternationalizationWordService internationalizationWordService;
    @Autowired
    private IInternationalizationService internationalizationService;

    private static List<LanguageTypeVo> languageTypeVos = null;

    static {
        languageTypeVos = new ArrayList<>();
        LanguageType[] values = LanguageType.values();
        if (values != null) {
            for (LanguageType a : values) {
                LanguageTypeVo vo = new LanguageTypeVo();
                vo.setCode(a.getCode());
                vo.setName(a.getName());
                languageTypeVos.add(vo);
            }
        }
    }


    @ApiOperation(value = "学员端获取语种列表", notes = "学员端获取语种列表")
    @GetMapping(value = "/public/languageType/getList")
    public Response<String> getList() {
        return Response.ok(languageTypeVos);
    }

}

