package com.yizhi.system.application.controller.api;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;

import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.yizhi.core.application.exception.BizException;
import com.yizhi.util.application.str.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.yizhi.core.application.cache.RedisCache;
import com.google.code.kaptcha.impl.DefaultKaptcha;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 16:10 2018/4/2
 * @Modified By
 */
@Api(tags = "获取验证码接口")
@Controller
@RequestMapping(value = "/api")
public class KaptchaController {

    @Autowired
    DefaultKaptcha defaultKaptcha;

    @Autowired
    private RedisCache redisCache;

    public static final String VRIFY_CODE = "vrifyCode";

    //@Value("${captcha.expire.time}")
    private Long captchaExpireTime = 600L; // 单位秒

    @RequestMapping(value = "/public/getCaptcha", method = RequestMethod.GET)
    public void defaultKaptcha(@ApiParam(required = true, value = "验证码生成请求的UUID") @RequestParam String captchaKey,
                               //@ApiParam(required = false, value = "请求随机数，区分每次请求") @RequestParam(required = false) String randomNum,
                               HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception{
        if(StringUtils.trimToEmpty(captchaKey).equals(StringUtils.EMPTY)){
            return;
        }
        byte[] captchaChallengeAsJpeg = null;
        ByteArrayOutputStream jpegOutputStream = new ByteArrayOutputStream();
        try {
            //生产验证码字符串并保存到session中
            String createText = defaultKaptcha.createText();
            /*httpServletRequest.getSession().setAttribute("vrifyCode", createText);*/
            redisCache.hset(VRIFY_CODE,captchaKey.trim(),createText,captchaExpireTime);

            //使用生产的验证码字符串返回一个BufferedImage对象并转为byte写入到byte数组中
            BufferedImage challenge = defaultKaptcha.createImage(createText);
            ImageIO.write(challenge, "jpg", jpegOutputStream);
        } catch (IllegalArgumentException e) {
            httpServletResponse.sendError(HttpServletResponse.SC_NOT_FOUND);
            return;
        }

        //定义response输出类型为image/jpeg类型，使用response输出流输出图片的byte数组
        captchaChallengeAsJpeg = jpegOutputStream.toByteArray();
        httpServletResponse.setHeader("Cache-Control", "no-store");
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0);
        httpServletResponse.setContentType("image/jpeg");
        ServletOutputStream responseOutputStream =
                httpServletResponse.getOutputStream();
        responseOutputStream.write(captchaChallengeAsJpeg);
        responseOutputStream.flush();
        responseOutputStream.close();
    }

    /**
     * 判断图形验证码是否正确
     * @param captchaKey 验证码请求前端生成的UUID
     * @param captchaVal 前端输入的验证码值
     * @return 相等验证通过返回true
     */
    public boolean validateCaptcha(String captchaKey,String captchaVal){
        boolean ret = false;
        Object redisVal = redisCache.hget(VRIFY_CODE,captchaKey);
        if(redisVal != null && StringUtils.equals(redisVal.toString(),captchaVal)){
            ret = true;
        }
        return ret;
    }
}
