package com.yizhi.system.application.controller.api;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.token.TokenHelper;
import com.yizhi.system.application.constant.OutsideUserMsg;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ILoginLogService;
import com.yizhi.system.application.service.SwhyKeyService;
import com.yizhi.system.application.util.Md5Util;
import com.yizhi.system.application.vo.OutsideSystemEbscnSsoVO;
import com.yizhi.util.application.constant.GlobalConstant;
import com.yizhi.util.application.domain.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.security.NoSuchAlgorithmException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;


/**
 * 外部系统光大证券的相关接口
 */
@RestController
@RequestMapping("/public/api/outside/ebscn")
public class OutsideSystemEbscnController {

    private static final Logger logger = LoggerFactory.getLogger(OutsideUserController.class);

    @Autowired
    private SwhyKeyService swhyKeyService;

    @Autowired
    private IAccountService accountService;

    @Autowired
    private TokenHelper tokenHelper;

    @Autowired
    private ILoginLogService loginLogService;

    /**
     * oa系统登录
     * @return
     */
    @PostMapping("/oa/pc/login")
    public Response ssoLogin(@RequestBody OutsideSystemEbscnSsoVO vo) {

        logger.info("请求参数={}", JSON.toJSONString(vo));

        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long siteId = context.getSiteId();
        String siteCode = context.getSiteCode();
        Long companyId = context.getCompanyId();
        String companyCode = context.getCompanyCode();

        logger.info("上下文站点id={} ，企业id={}", siteId, companyId );

        String userName = vo.getUserName();

        String appId = vo.getAppId();
        String sign = vo.getSign();

        // 判断用户名是否为空
        if(StringUtils.EMPTY.equals(StringUtils.trimToEmpty(userName))){
            return Response.fail(OutsideUserMsg.USER_IS_NULL.getCode(),OutsideUserMsg.USER_IS_NULL.getName());
        }
        try {
            // 验证appId
            // 首先验证appId是否是平台的合法参数
            com.yizhi.system.application.domain.SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            logger.info("配置信息={}", JSON.toJSONString(swhyKeyConfig));
            // 获取相关配置
            //Integer rsaState = swhyKeyConfig.getRsaState();
            //String privateKey = swhyKeyConfig.getPrivateKey();
            // 和光大证券oa系统对接人 约定的PublicKey（目前根据企业配置在数据库）
            //String publicKey = swhyKeyConfig.getPublicKey();

            String appSecret = swhyKeyConfig.getAppSecret();

            // 生成签名
            String signStr = userName+appSecret+LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String generateSign = Md5Util.generateLowerCase(signStr);
            if(!generateSign.equals(sign)){
                return Response.fail(OutsideUserMsg.TOKEN_INVALID.getCode(),OutsideUserMsg.TOKEN_INVALID.getName());
            }
            // 获取用户信息
            EntityWrapper<com.yizhi.system.application.domain.Account> ew = QueryUtil.condition(new com.yizhi.system.application.domain.Account());
            ew.eq("name",userName).eq("company_id",companyId).eq("enabled",true);
            com.yizhi.system.application.domain.Account account = accountService.selectOne(ew);
            if(account == null){
                throw new BizException(OutsideUserMsg.USER_NOT_EXISTS.getCode(),OutsideUserMsg.USER_NOT_EXISTS.getName());
            }
            // 生成登录信息
            account.setPassword("");
            Map<String, Object> info = new HashMap<String, Object>();
            info.put(GlobalConstant.ACCOUNT_ID, String.valueOf(account.getId()));
            info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
            info.put(GlobalConstant.COMPANY_ID, companyId.toString());
            info.put(GlobalConstant.COMPANY_NAME, context.getCompanyName());
            info.put(GlobalConstant.SITE_ID, siteId.toString());
            info.put(GlobalConstant.SITE_CODE, context.getSiteCode());
            info.put(GlobalConstant.SITE_NAME, context.getSiteName());
            String token = tokenHelper.createToken(account.getName(), info);
            // 返回信息
            Map<String, Object> retMap = new HashMap<>();
            retMap.put("userInfo", account);
            retMap.put(GlobalConstant.TOKEN_HEADER, token);
            retMap.put("siteId", siteId.toString());
            // 添加日志
            //转换成PC
            addLoginRecord(account.getId(), companyId, siteId, account.getOrgId(),
                    1);
            return Response.ok(retMap);

        } catch (BizException e) {
            logger.info("业务异常={}", JSON.toJSONString(e));
            return Response.fail(e.getCode(),e.getMsg());
        } catch (NoSuchAlgorithmException e) {
            logger.info("系统异常={}", e);
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(),OutsideUserMsg.SYSTEM_ERROR.getName());
        }
    }


    /**
     * 获取appId 配置
     * @param companyId
     * @param appId
     * @return
     * @throws BizException
     */
    public com.yizhi.system.application.domain.SwhyKey getSwhyKey(Long companyId, String appId) throws BizException {
        EntityWrapper<com.yizhi.system.application.domain.SwhyKey> ewSk = QueryUtil.condition(new com.yizhi.system.application.domain.SwhyKey());
        ewSk.eq("company_id", companyId).eq("uuid",appId);
        com.yizhi.system.application.domain.SwhyKey swhyKeyConfig = swhyKeyService.selectOne(ewSk);
        if(swhyKeyConfig == null){ //appId 不存在
            throw new BizException(OutsideUserMsg.APPID_NOT_EXIST.getCode(),OutsideUserMsg.APPID_NOT_EXIST.getName());
        }
        // 验证appId是否过期
        Date appIdExpireTime = swhyKeyConfig.getExpireTime();
        if(appIdExpireTime.getTime() < System.currentTimeMillis()){
            throw new BizException(OutsideUserMsg.APPID_EXPIRED_TIME.getCode(),OutsideUserMsg.APPID_EXPIRED_TIME.getName());
        }
        return swhyKeyConfig;
    }

    /**
     * 添加登陆记录
     */
    private void addLoginRecord(long accountId, long companyId, long siteId, long orgId, int type) {
        // accountService.updateById(account);
        com.yizhi.system.application.domain.LoginLog loginLog = new com.yizhi.system.application.domain.LoginLog();
        loginLog.setAccountId(accountId);
        loginLog.setCompanyId(companyId);
        loginLog.setSiteId(siteId);
        loginLog.setOrgId(orgId);
        loginLog.setLoginDate(new Date());
        loginLog.setLoginType(type);
        loginLogService.insert(loginLog);

    }
}
