package com.yizhi.system.application.controller.api;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.constant.OutsideUserMsg;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.service.using.OrganizationIndexService;
import com.yizhi.system.application.task.OutsideUserSyncTask;
import com.yizhi.core.application.token.TokenHelper;
import com.yizhi.system.application.util.SaltUtil;
import com.yizhi.util.application.constant.GlobalConstant;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.encrypt.ShaEncrypt;
import com.yizhi.system.application.vo.OutsideUserSyncVO;
import com.yizhi.system.application.vo.OutsideUserVO;
import com.yizhi.system.application.vo.SaltAccountVO;
import com.yizhi.system.application.vo.domain.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 外部用户接入处理
 */
@RestController
@RequestMapping("/public/api/outside/user")
public class OutsideUserController {

    private static final String SPLIT = "##";

    private static final String SPLIT_S = "~~";

    private static final Long ACCOUNT_ID = 999L;

    @Autowired
    private SwhyKeyService swhyKeyService;

    @Autowired
    private IOrganizationService organizationService;

    @Autowired
    private IdGenerator idGenerator;

    @Autowired
    private OrganizationIndexService organizationIndexService;

    @Autowired
    private IAccountService accountService;

    @Autowired
    private TokenHelper tokenHelper;

    @Autowired
    private ILoginLogService loginLogService;

    @Autowired
    private IOutsideOperatorRecodeService outsideOperatorRecodeService;

    @Autowired
    private IOutsideRootOrgsService outsideRootOrgsService;

    @Autowired
    private OutsideUserSyncTask outsideUserSyncTask;

    private static final Logger logger = LoggerFactory.getLogger(OutsideUserController.class);

    @PostMapping("/full/sync")
    public Response fullSync(@RequestBody OutsideUserSyncVO outsideUserSyncVO) {

        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long siteId = context.getSiteId();
        String siteCode = context.getSiteCode();
        Long companyId = context.getCompanyId();
        String companyCode = context.getCompanyCode();

        /*Response e = syncData(outsideUserSyncVO, siteId, siteCode, companyId, companyCode);
        if (e != null) return e;*/
        // 优化成异步处理
        Map<String, Object> param = new HashMap<>();
        param.put("requestParam", outsideUserSyncVO);
        logger.info("siteId={},siteCode={}, companyId={}, companyCode={}", siteId, siteCode, companyId, companyCode);
        param.put("siteId", siteId);
        param.put("siteCode", siteCode);
        param.put("companyId", companyId);
        param.put("companyCode", companyCode);
        outsideUserSyncTask.execute(param, true);

        return Response.ok();
    }

    private Response syncData(OutsideUserSyncVO outsideUserSyncVO, Long siteId, String siteCode, Long companyId, String companyCode) {
        String requestBody = JSON.toJSONString(outsideUserSyncVO);
        logger.info("请求的对接数据={}", requestBody);

        com.yizhi.system.application.domain.OutsideOperatorRecode outsideOperatorRecode = new com.yizhi.system.application.domain.OutsideOperatorRecode();

        try {
            //LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"))
            String path = FileConstant.SAVE_PATH + File.separator + "outsideUser" + File.separator + companyCode + File.separator + siteCode;
            path += File.separator + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH"));
            Path filePath = Paths.get(path);
            if (Files.notExists(filePath)) {
                Files.createDirectories(filePath);
            }
            String fileName = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH_mm_ss_SSS")) + ".txt";
            Files.write(Paths.get(filePath.toAbsolutePath().toString(), fileName), requestBody.getBytes());
            //阿里云返回url
            //upLoadUrl = OssUpload.upload(path, fileName);

            outsideOperatorRecode.setId(idGenerator.generate());
            outsideOperatorRecode.setCompanyCode(companyCode);
            outsideOperatorRecode.setCompanyId(companyId);
            outsideOperatorRecode.setSiteCode(siteCode);
            outsideOperatorRecode.setSiteId(siteId);
            outsideOperatorRecode.setRequestContextPath(Paths.get(filePath.toAbsolutePath().toString(), fileName).toAbsolutePath().toString());
            outsideOperatorRecode.setType(1);
            outsideOperatorRecode.setStatus(0);

        } catch (IOException e) {
            logger.info("生成文件异常：{}", e);
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(), OutsideUserMsg.SYSTEM_ERROR.getName());
        }


        try {

            boolean isNewOrg = false;
            // 首先验证appId是否是平台的合法参数
            String appId = outsideUserSyncVO.getAppId();
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();

            // 遍历用户信息
            List<OutsideUserVO> users = outsideUserSyncVO.getUsers();

            // 获取对接组织root的列表
            Map<String, Long> orgSelectd = new HashMap<>();
            String orgRoot = "";
            EntityWrapper<com.yizhi.system.application.domain.OutsideRootOrgs> ewOro = QueryUtil.condition(new com.yizhi.system.application.domain.OutsideRootOrgs());
            ewOro.eq("company_id", companyId).eq("site_id", siteId);
            com.yizhi.system.application.domain.OutsideRootOrgs dbOutsideRootOrgs = outsideRootOrgsService.selectOne(ewOro);
            String dbOrgIds = StringUtils.trimToEmpty(dbOutsideRootOrgs.getRootOrgs());
            if (dbOutsideRootOrgs != null && !StringUtils.EMPTY.equals(dbOrgIds)) {
                String[] dbOrgIdsArr = dbOrgIds.split(SPLIT);
                for (String itemOrgId : dbOrgIdsArr) {
                    String orgIdTem = StringUtils.trimToEmpty(itemOrgId);
                    if (!StringUtils.EMPTY.equals(orgIdTem)) {
                        com.yizhi.system.application.domain.Organization dbOrganization = organizationService.selectById(Long.valueOf(orgIdTem));
                        orgRoot += dbOrganization.getName() + SPLIT;
                        orgSelectd.put(orgRoot, Long.valueOf(orgIdTem));
                    }
                }
            }
            // 检查必须字段并解密字段信息
            decryptUserInfo(rsaState, privateKey, users, orgRoot);
            logger.info("解密请求数据 = {}", JSON.toJSONString(users));
            // 开始同步用户
            // 1 查看有多少用户组
            Set<String> orgGroups = users.stream().parallel().map(orgG -> orgG.getOrgNames()).collect(Collectors.toSet());
            isNewOrg = syncOrg(siteCode, companyId, companyCode, orgSelectd, orgGroups);
            logger.info("用户组的列表 = {}", JSON.toJSONString(orgSelectd));

            // 2 开始处理用户
            // 查询数据库的某企业下启用的用户列表
            List<OutsideUserVO> existsOutsideUserVO = accountService.getCompanyOutsideUsers(companyId, null);
            if (CollectionUtils.isEmpty(existsOutsideUserVO)) { // 首次同步（全是新增用户）
                logger.info("数据库不包含用户，开始新增用户");
                addUsers(companyId, siteId, users, orgSelectd, true);
            } else {
                logger.info("数据库包含用户，开始新增用户");
                // 把同步的用户的组织id设置并获取用户名的set集合
                Map<String, OutsideUserVO> syncUserNames = new HashMap<>();
                logger.info("组织架构={}", JSON.toJSONString(orgSelectd));
                for (OutsideUserVO syncUser : users) {
                    logger.info("遍历每一个用户={}", JSON.toJSONString(syncUser));
                    syncUser.setOrgId(orgSelectd.get(syncUser.getOrgNames()));
                    syncUser.setSiteId(siteId);
                    syncUserNames.put(syncUser.getName(), syncUser);
                }
                Map<String, OutsideUserVO> dbUserNames = existsOutsideUserVO.stream().parallel()
                        .collect(Collectors.toMap(keyObj -> keyObj.getName(), valObj -> valObj));
                // 准备更新，添加，删除操作
                Set<String> syncUserNameSet = syncUserNames.keySet();
                Set<String> dbUserNameSet = dbUserNames.keySet();
                // 需要更新的用户信息
                Set<String> updateUsers = new HashSet<>();
                updateUsers.addAll(syncUserNameSet);
                updateUsers.retainAll(dbUserNameSet);
                if (!CollectionUtils.isEmpty(updateUsers)) {
                    String updateStatus = updateUsers(syncUserNames, dbUserNames, updateUsers, siteId);
                    if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(updateStatus))) {
                        outsideOperatorRecode.setStatus(1);
                        outsideOperatorRecode.setDesc(updateStatus);
                    }
                }
                // 需要创建用户
                Set<String> newUsers = new HashSet<>();
                newUsers.addAll(syncUserNameSet);
                newUsers.removeAll(dbUserNameSet);
                if (!CollectionUtils.isEmpty(newUsers)) {
                    List<OutsideUserVO> addUsers = new ArrayList<>();
                    for (String addUserName : newUsers) {
                        addUsers.add(syncUserNames.get(addUserName));
                    }
                    addUsers(companyId, siteId, addUsers, null, false);
                }
                // 需要删除的用户（由于有系统的创建用户，不能直接通过同步删除数据）
                /*Set<String> delUsers = new HashSet<>();
                delUsers.addAll(dbUserNameSet);
                delUsers.removeAll(syncUserNameSet);
                if(!CollectionUtils.isEmpty(delUsers)){
                    List<Account> delUserList = new ArrayList<>();
                    for(String delUserName : delUsers){
                        OutsideUserVO delItem = dbUserNames.get(delUserName);
                        Account delAccount = new Account();
                        delAccount.setId(delAccount.getId());
                        delAccount.setEnabled(false);
                        delAccount.setUpdateTime(new Date());
                        delAccount.setUpdateById(ACCOUNT_ID);
                        delAccount.setUpdateByName("system");
                        delUserList.add(delAccount);
                    }
                    accountService.updateBatchById(delUserList);
                }*/
                // 全部的用户
                /*Set<String> allUsers = new HashSet<>();
                allUsers.addAll(syncUserNameSet);
                allUsers.addAll(dbUserNameSet);*/

            }

            if (isNewOrg) {
                // 添加组织索引信息
                try {
                    organizationIndexService.addInitTask(companyId);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (BizException e) {
            outsideOperatorRecode.setStatus(1);
            outsideOperatorRecode.setDesc(e.getMsg());
            logger.info("业务异常={}", JSON.toJSONString(e));
            return Response.fail(e.getCode(), e.getMsg());
        } catch (Exception e) {
            outsideOperatorRecode.setStatus(1);
            outsideOperatorRecode.setDesc(e.getMessage());
            logger.info("系统异常={}", e);
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(), OutsideUserMsg.SYSTEM_ERROR.getName());
        }
        outsideOperatorRecodeService.insert(outsideOperatorRecode);
        return null;
    }

    @PostMapping("/batch/add")
    public Response batchAdd(@RequestBody OutsideUserSyncVO outsideUserSyncVO) {

        logger.info("请求的对接数据={}", JSON.toJSONString(outsideUserSyncVO));

        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long siteId = context.getSiteId();
        String siteCode = context.getSiteCode();
        Long companyId = context.getCompanyId();
        String companyCode = context.getCompanyCode();

        try {

            boolean isNewOrg = false;
            // 首先验证appId是否是平台的合法参数
            String appId = outsideUserSyncVO.getAppId();
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();

            // 遍历用户信息
            List<OutsideUserVO> users = outsideUserSyncVO.getUsers();
            // 获取对接组织root的列表
            String orgRoot = "";
            EntityWrapper<com.yizhi.system.application.domain.OutsideRootOrgs> ewOro = QueryUtil.condition(new com.yizhi.system.application.domain.OutsideRootOrgs());
            ewOro.eq("company_id", companyId).eq("site_id", siteId);
            com.yizhi.system.application.domain.OutsideRootOrgs dbOutsideRootOrgs = outsideRootOrgsService.selectOne(ewOro);
            String dbOrgIds = StringUtils.trimToEmpty(dbOutsideRootOrgs.getRootOrgs());
            if (dbOutsideRootOrgs != null && !StringUtils.EMPTY.equals(dbOrgIds)) {
                String[] dbOrgIdsArr = dbOrgIds.split(SPLIT);
                for (String itemOrgId : dbOrgIdsArr) {
                    String orgIdTem = StringUtils.trimToEmpty(itemOrgId);
                    if (!StringUtils.EMPTY.equals(orgIdTem)) {
                        com.yizhi.system.application.domain.Organization dbOrganization = organizationService.selectById(Long.valueOf(orgIdTem));
                        orgRoot += dbOrganization.getName() + SPLIT;
                    }
                }
            }
            // 检查必须字段并解密字段信息
            decryptUserInfo(rsaState, privateKey, users, orgRoot);
            // 开始同步用户
            // 1 查看有多少用户组
            Map<String, Long> orgSelectd = new HashMap<>();
            Set<String> orgGroups = users.stream().parallel().map(orgG -> orgG.getOrgNames()).collect(Collectors.toSet());
            isNewOrg = syncOrg(siteCode, companyId, companyCode, orgSelectd, orgGroups);

            // 2 开始处理用户
            // 查询数据库的某企业下启用的用户列表
            List<OutsideUserVO> existsOutsideUserVO = accountService.getCompanyOutsideUsers(companyId, 1);
            if (CollectionUtils.isEmpty(existsOutsideUserVO)) { // 首次同步（全是新增用户）
                addUsers(companyId, siteId, users, orgSelectd, true);
            } else {
                // 把同步的用户的组织id设置并获取用户名的set集合
                Map<String, OutsideUserVO> syncUserNames = new HashMap<>();
                for (OutsideUserVO syncUser : users) {
                    syncUser.setOrgId(orgSelectd.get(syncUser.getOrgNames()));
                    syncUserNames.put(syncUser.getName(), syncUser);
                }
                Map<String, OutsideUserVO> dbUserNames = existsOutsideUserVO.stream().parallel()
                        .collect(Collectors.toMap(keyObj -> keyObj.getName(), valObj -> valObj));
                // 准备更新，添加，删除操作
                Set<String> syncUserNameSet = syncUserNames.keySet();
                Set<String> dbUserNameSet = dbUserNames.keySet();
                // 需要更新的用户信息
                Set<String> updateUsers = new HashSet<>();
                updateUsers.addAll(syncUserNameSet);
                updateUsers.retainAll(dbUserNameSet);
                if (!CollectionUtils.isEmpty(updateUsers)) {
                    updateUsers(syncUserNames, dbUserNames, updateUsers, siteId);
                }
                // 需要创建用户
                Set<String> newUsers = new HashSet<>();
                newUsers.addAll(syncUserNameSet);
                newUsers.removeAll(dbUserNameSet);
                if (!CollectionUtils.isEmpty(newUsers)) {
                    List<OutsideUserVO> addUsers = new ArrayList<>();
                    for (String addUserName : newUsers) {
                        addUsers.add(syncUserNames.get(addUserName));
                    }
                    addUsers(companyId, siteId, addUsers, null, false);
                }
            }

            if (isNewOrg) {
                // 添加组织索引信息
                try {
                    organizationIndexService.addInitTask(companyId);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        } catch (Exception e) {
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(), OutsideUserMsg.SYSTEM_ERROR.getName());
        }
        return Response.ok();
    }


    @GetMapping("/status")
    public Response status(@RequestParam("appId") String appId, @RequestParam("name") String name) {
        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long companyId = context.getCompanyId();
        try {
            boolean isNewOrg = false;
            // 首先验证appId是否是平台的合法参数
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();
            // 验证必须字段以及字段加密情况
            if (StringUtils.trimToEmpty(name).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_NAME_IS_EMPTY.getName());
            }
            if (Integer.valueOf(0).equals(rsaState)) { // 开启RSA加密字段
                try {
                    name = SaltUtil.decryptNosalt(name, privateKey);
                } catch (Exception e) {
                    throw new BizException(OutsideUserMsg.USER_INFO_DECRYP_ERROR.getCode(), OutsideUserMsg.USER_INFO_DECRYP_ERROR.getName());
                }
            }
            // 获取用户信息
            EntityWrapper<com.yizhi.system.application.domain.Account> ew = QueryUtil.condition(new com.yizhi.system.application.domain.Account());
            ew.eq("name", name).eq("company_id", companyId).eq("enabled", true);
            Map<String, Object> retMap = new HashMap<>();
            com.yizhi.system.application.domain.Account account = accountService.selectOne(ew);
            if (account == null) {
                throw new BizException(OutsideUserMsg.USER_NOT_EXISTS.getCode(), OutsideUserMsg.USER_NOT_EXISTS.getName());
            }
            retMap.put("status", account.getEnabled() ? 1 : 0);
            return Response.ok(retMap);
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        } catch (Exception e) {
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(), OutsideUserMsg.SYSTEM_ERROR.getName());
        }
    }


    @GetMapping("/disable")
    public Response disable(@RequestParam("appId") String appId, @RequestParam("name") String name) {
        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long companyId = context.getCompanyId();
        try {
            boolean isNewOrg = false;
            // 首先验证appId是否是平台的合法参数
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();
            // 验证必须字段以及字段加密情况
            if (StringUtils.trimToEmpty(name).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_NAME_IS_EMPTY.getName());
            }
            if (Integer.valueOf(0).equals(rsaState)) { // 开启RSA加密字段
                try {
                    name = SaltUtil.decryptNosalt(name, privateKey);
                } catch (Exception e) {
                    throw new BizException(OutsideUserMsg.USER_INFO_DECRYP_ERROR.getCode(), OutsideUserMsg.USER_INFO_DECRYP_ERROR.getName());
                }
            }
            // 获取用户信息
            EntityWrapper<com.yizhi.system.application.domain.Account> ew = QueryUtil.condition(new com.yizhi.system.application.domain.Account());
            ew.eq("name", name).eq("company_id", companyId).eq("enabled", true);

            com.yizhi.system.application.domain.Account account = accountService.selectOne(ew);
            if (account == null) {
                throw new BizException(OutsideUserMsg.USER_NOT_EXISTS.getCode(), OutsideUserMsg.USER_NOT_EXISTS.getName());
            }

            com.yizhi.system.application.domain.Account accountUp = new com.yizhi.system.application.domain.Account();
            accountUp.setId(account.getId());
            accountUp.setEnabled(false);
            accountUp.setUpdateById(ACCOUNT_ID);
            accountUp.setUpdateByName("system");
            accountUp.setUpdateTime(new Date());
            accountService.updateById(accountUp);
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        } catch (Exception e) {
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(), OutsideUserMsg.SYSTEM_ERROR.getName());
        }
        return Response.ok();
    }


    @GetMapping("/update")
    public Response update(@RequestBody OutsideUserSyncVO outsideUserSyncVO) {

        logger.info("请求的对接数据={}", JSON.toJSONString(outsideUserSyncVO));

        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long siteId = context.getSiteId();
        String siteCode = context.getSiteCode();
        Long companyId = context.getCompanyId();
        String companyCode = context.getCompanyCode();

        try {

            boolean isNewOrg = false;
            // 首先验证appId是否是平台的合法参数
            String appId = outsideUserSyncVO.getAppId();
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();

            // 遍历用户信息
            List<OutsideUserVO> users = outsideUserSyncVO.getUsers();
            // 获取对接组织root的列表
            String orgRoot = "";
            EntityWrapper<com.yizhi.system.application.domain.OutsideRootOrgs> ewOro = QueryUtil.condition(new com.yizhi.system.application.domain.OutsideRootOrgs());
            ewOro.eq("company_id", companyId).eq("site_id", siteId);
            com.yizhi.system.application.domain.OutsideRootOrgs dbOutsideRootOrgs = outsideRootOrgsService.selectOne(ewOro);
            String dbOrgIds = StringUtils.trimToEmpty(dbOutsideRootOrgs.getRootOrgs());
            if (dbOutsideRootOrgs != null && !StringUtils.EMPTY.equals(dbOrgIds)) {
                String[] dbOrgIdsArr = dbOrgIds.split(SPLIT);
                for (String itemOrgId : dbOrgIdsArr) {
                    String orgIdTem = StringUtils.trimToEmpty(itemOrgId);
                    if (!StringUtils.EMPTY.equals(orgIdTem)) {
                        com.yizhi.system.application.domain.Organization dbOrganization = organizationService.selectById(Long.valueOf(orgIdTem));
                        orgRoot += dbOrganization.getName() + SPLIT;
                    }
                }
            }
            // 检查必须字段并解密字段信息
            decryptUserInfo(rsaState, privateKey, users, orgRoot);
            // 开始同步用户
            // 1 查看有多少用户组
            Map<String, Long> orgSelectd = new HashMap<>();
            Set<String> orgGroups = users.stream().parallel().map(orgG -> orgG.getOrgNames()).collect(Collectors.toSet());
            isNewOrg = syncOrg(siteCode, companyId, companyCode, orgSelectd, orgGroups);

            // 2 开始处理用户
            // 查询数据库的某企业下启用的用户列表
            EntityWrapper<com.yizhi.system.application.domain.Account> ew = QueryUtil.condition(new com.yizhi.system.application.domain.Account());
            ew.in("name", users.stream().parallel().map(itemUserName -> itemUserName.getName()).collect(Collectors.toSet()));
            ew.eq("company_id", companyId).eq("enabled", true);
            List<com.yizhi.system.application.domain.Account> accountList = accountService.selectList(ew);
            if (!CollectionUtils.isEmpty(accountList)) {

            }
            List<OutsideUserVO> existsOutsideUserVO = accountService.getCompanyOutsideUsers(companyId, 1);
            if (CollectionUtils.isEmpty(existsOutsideUserVO)) { // 首次同步（全是新增用户）
                addUsers(companyId, siteId, users, orgSelectd, true);
            } else {
                // 把同步的用户的组织id设置并获取用户名的set集合
                Map<String, OutsideUserVO> syncUserNames = new HashMap<>();
                for (OutsideUserVO syncUser : users) {
                    syncUser.setOrgId(orgSelectd.get(syncUser.getOrgNames()));
                    syncUserNames.put(syncUser.getName(), syncUser);
                }
                Map<String, OutsideUserVO> dbUserNames = existsOutsideUserVO.stream().parallel()
                        .collect(Collectors.toMap(keyObj -> keyObj.getName(), valObj -> valObj));
                // 准备更新，添加，删除操作
                Set<String> syncUserNameSet = syncUserNames.keySet();
                Set<String> dbUserNameSet = dbUserNames.keySet();
                // 需要更新的用户信息
                Set<String> updateUsers = new HashSet<>();
                updateUsers.addAll(syncUserNameSet);
                updateUsers.retainAll(dbUserNameSet);
                if (!CollectionUtils.isEmpty(updateUsers)) {
                    updateUsers(syncUserNames, dbUserNames, updateUsers, siteId);
                }
                // 需要创建用户
                Set<String> newUsers = new HashSet<>();
                newUsers.addAll(syncUserNameSet);
                newUsers.removeAll(dbUserNameSet);
                if (!CollectionUtils.isEmpty(newUsers)) {
                    List<OutsideUserVO> addUsers = new ArrayList<>();
                    for (String addUserName : newUsers) {
                        addUsers.add(syncUserNames.get(addUserName));
                    }
                    addUsers(companyId, siteId, addUsers, null, false);
                }
            }

            if (isNewOrg) {
                // 添加组织索引信息
                try {
                    organizationIndexService.addInitTask(companyId);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        } catch (Exception e) {
            return Response.fail(OutsideUserMsg.SYSTEM_ERROR.getCode(), OutsideUserMsg.SYSTEM_ERROR.getName());
        }
        return Response.ok();
    }

    @PostMapping("/token")
    public Response token(@RequestBody SaltAccountVO saltAccountVO) {
        logger.info("请求的对接数据={}", JSON.toJSONString(saltAccountVO));
        RequestContext context = ContextHolder.get();
        // 获取企业id和站点id
        Long siteId = context.getSiteId();
        Long companyId = context.getCompanyId();
        try {
            // 首先验证appId是否是平台的合法参数
            String appId = saltAccountVO.getAppId();
            SwhyKey swhyKeyConfig = getSwhyKey(companyId, appId);
            // 获取相关配置
            Integer rsaState = swhyKeyConfig.getRsaState();
            String privateKey = swhyKeyConfig.getPrivateKey();
            // 验证必须字段以及字段加密情况
            String name = saltAccountVO.getName();
            if (StringUtils.trimToEmpty(name).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_NAME_IS_EMPTY.getName());
            }
            if (Integer.valueOf(0).equals(rsaState)) { // 开启RSA加密字段
                try {
                    name = SaltUtil.decryptNosalt(name, privateKey);
                } catch (Exception e) {
                    throw new BizException(OutsideUserMsg.USER_INFO_DECRYP_ERROR.getCode(), OutsideUserMsg.USER_INFO_DECRYP_ERROR.getName());
                }
            }
            // 获取用户信息
            EntityWrapper<com.yizhi.system.application.domain.Account> ew = QueryUtil.condition(new com.yizhi.system.application.domain.Account());
            ew.eq("name", name).eq("company_id", companyId).eq("enabled", true);
            com.yizhi.system.application.domain.Account account = accountService.selectOne(ew);
            if (account == null) {
                throw new BizException(OutsideUserMsg.USER_NOT_EXISTS.getCode(), OutsideUserMsg.USER_NOT_EXISTS.getName());
            }
            // 生成登录信息
            account.setPassword("");
            Map<String, Object> info = new HashMap<String, Object>();
            info.put(GlobalConstant.ACCOUNT_ID, String.valueOf(account.getId()));
            info.put(GlobalConstant.COMPANY_CODE, context.getCompanyCode());
            info.put(GlobalConstant.COMPANY_ID, companyId.toString());
            info.put(GlobalConstant.COMPANY_NAME, context.getCompanyName());
            info.put(GlobalConstant.SITE_ID, siteId.toString());
            info.put(GlobalConstant.SITE_CODE, context.getSiteCode());
            info.put(GlobalConstant.SITE_NAME, context.getSiteName());
            String token = tokenHelper.createToken(account.getName(), info);
            // 返回信息
            Map<String, Object> retMap = new HashMap<>();
            retMap.put("userInfo", account);
            retMap.put(GlobalConstant.TOKEN_HEADER, token);
            retMap.put("siteId", siteId.toString());
            // 添加日志
            Integer terminalType = saltAccountVO.getTerminalType();
            //转换成PC
            if (terminalType == 4) {
                terminalType = 1;
            }
            addLoginRecord(account.getId(), companyId, siteId, account.getOrgId(),
                    terminalType);
            return Response.ok(retMap);
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 添加登陆记录
     */
    private void addLoginRecord(long accountId, long companyId, long siteId, long orgId, int type) {
        // accountService.updateById(account);
        com.yizhi.system.application.domain.LoginLog loginLog = new com.yizhi.system.application.domain.LoginLog();
        loginLog.setAccountId(accountId);
        loginLog.setCompanyId(companyId);
        loginLog.setSiteId(siteId);
        loginLog.setOrgId(orgId);
        loginLog.setLoginDate(new Date());
        loginLog.setLoginType(type);
        loginLogService.insert(loginLog);

    }

    /**
     * 获取appId 配置
     *
     * @param companyId
     * @param appId
     * @return
     * @throws BizException
     */
    public SwhyKey getSwhyKey(Long companyId, String appId) throws BizException {
        EntityWrapper<com.yizhi.system.application.domain.SwhyKey> ewSk = QueryUtil.condition(new com.yizhi.system.application.domain.SwhyKey());
        ewSk.eq("company_id", companyId).eq("uuid", appId);
        com.yizhi.system.application.domain.SwhyKey swhyKeyConfig = swhyKeyService.selectOne(ewSk);
        if (swhyKeyConfig == null) { //appId 不存在
            throw new BizException(OutsideUserMsg.APPID_NOT_EXIST.getCode(), OutsideUserMsg.APPID_NOT_EXIST.getName());
        }
        // 验证appId是否过期
        Date appIdExpireTime = swhyKeyConfig.getExpireTime();
        if (appIdExpireTime.getTime() < System.currentTimeMillis()) {
            throw new BizException(OutsideUserMsg.APPID_EXPIRED_TIME.getCode(), OutsideUserMsg.APPID_EXPIRED_TIME.getName());
        }
        SwhyKey swhyKey = new SwhyKey();
        BeanUtils.copyProperties(swhyKeyConfig, swhyKey);
        return swhyKey;
    }

    /**
     * 检查非空字段并解密信息（如果配置了加密）
     *
     * @param rsaState
     * @param privateKey
     * @param users
     */
    private static void decryptUserInfo(Integer rsaState, String privateKey, List<OutsideUserVO> users, String orgRoot) {
        if (CollectionUtils.isEmpty(users)) {
            throw new BizException(OutsideUserMsg.USERS_IS_EMPTY.getCode(), OutsideUserMsg.USERS_IS_EMPTY.getName());
        }
        for (OutsideUserVO user : users) {
            // 验证必须字段
            String name = user.getName();
            String fullName = user.getFullName();
            String orgNames = user.getOrgNames();
            String status = user.getStatus();
            if (StringUtils.trimToEmpty(name).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_NAME_IS_EMPTY.getName());
            }
            if (StringUtils.trimToEmpty(fullName).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_FULL_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_FULL_NAME_IS_EMPTY.getName());
            }
            if (StringUtils.trimToEmpty(orgNames).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getName());
            }
            if (StringUtils.trimToEmpty(orgNames).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getCode(), OutsideUserMsg.USER_ORG_NAME_IS_EMPTY.getName());
            }
            if (StringUtils.trimToEmpty(status).isEmpty()) {
                throw new BizException(OutsideUserMsg.USER_STATUS_EXISTS.getCode(), OutsideUserMsg.USER_STATUS_EXISTS.getName());
            }
            if (Integer.valueOf(0).equals(rsaState)) { // 开启RSA加密字段
                // 对加密字段进行RSA解密
                try {
                    user.setName(SaltUtil.decryptNosalt(name, privateKey));
                    user.setFullName(SaltUtil.decryptNosalt(fullName, privateKey));
                    String decryOrg = SaltUtil.decryptNosalt(orgNames, privateKey);
                    user.setOrgNames(orgRoot + decryOrg);
                    /*String pwd = user.getPassword();
                    if(!StringUtils.trimToEmpty(pwd).isEmpty()){
                        user.setPassword(SaltUtil.decryptNosalt(pwd, privateKey));
                    }*/
                    String email = user.getEmail();
                    if (!StringUtils.trimToEmpty(email).isEmpty()) {
                        user.setEmail(SaltUtil.decryptNosalt(email, privateKey));
                    }
                    String mobile = user.getMobile();
                    if (!StringUtils.trimToEmpty(mobile).isEmpty()) {
                        user.setMobile(SaltUtil.decryptNosalt(mobile, privateKey));
                    }
                    String workNum = user.getWorkNum();
                    if (!StringUtils.trimToEmpty(workNum).isEmpty()) {
                        user.setWorkNum(SaltUtil.decryptNosalt(workNum, privateKey));
                    }
                    String sex = user.getSex();
                    if (!StringUtils.trimToEmpty(sex).isEmpty()) {
                        user.setSex(SaltUtil.decryptNosalt(sex, privateKey));
                    }
                    String position = user.getPosition();
                    if (!StringUtils.trimToEmpty(position).isEmpty()) {
                        user.setPosition(SaltUtil.decryptNosalt(position, privateKey));
                    }
                    String idNumber = user.getIdNumber();
                    if (!StringUtils.trimToEmpty(idNumber).isEmpty()) {
                        user.setIdNumber(SaltUtil.decryptNosalt(idNumber, privateKey));
                    }
                } catch (Exception e) {
                    throw new BizException(OutsideUserMsg.USER_INFO_DECRYP_ERROR.getCode(), OutsideUserMsg.USER_INFO_DECRYP_ERROR.getName());
                }
            }
        }
    }


    /**
     * 批量新增用户
     *
     * @param companyId
     * @param users
     * @param orgSelectd
     */
    private void addUsers(Long companyId, Long siteId, List<OutsideUserVO> users, Map<String, Long> orgSelectd, boolean orgIdByMap) {
        // 循环生成新用户信息
        List<com.yizhi.system.application.domain.Account> addAccounts = new ArrayList<>();
        for (OutsideUserVO newUser : users) {
            com.yizhi.system.application.domain.Account user = new com.yizhi.system.application.domain.Account();
            Long userId = idGenerator.generate();
            user.setId(userId);
            user.setName(newUser.getName());
            String idNumber = newUser.getIdNumber();
            if (idNumber != null) {
                int strLength = idNumber.length();
                int indexStart = strLength - 6;
                String pwd = idNumber.substring(indexStart);
                user.setPassword(ShaEncrypt.encryptNewPassword(pwd));
            } else {
                user.setPassword(ShaEncrypt.encryptNewPassword("123456")); // 密码（必须要指定）
            }

            // 备注字段2 存放站点信息
            user.setRemarkSecond(siteId.toString());
            // 用户在离职状态
            String status = newUser.getStatus();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(status))) {
                // 备注字段1 存放对接用户的状态信息
                user.setRemarkFirst(newUser.getStatus());
                if ("2".equals(status)) {
                    user.setEnabled(false);
                } else {
                    user.setEnabled(true);
                }
            }
            //user.setHeadPortrait(""); // 用户头像
            user.setEnabled(true);
            user.setLocked(false);
            if (orgIdByMap) {
                user.setOrgId(orgSelectd.get(newUser.getOrgNames()));
            } else {
                user.setOrgId(newUser.getOrgId());
            }
            user.setCompanyId(companyId);
            //user.setTelephone(null);
            user.setMobile(newUser.getMobile());
            user.setEmail(newUser.getEmail());
            user.setExpiredType(1);
            user.setEnabledTime(new Date());
            user.setSex(newUser.getSex());
            user.setPosition(newUser.getPosition());
            user.setFullName(newUser.getFullName());
            user.setWorkNum(newUser.getWorkNum());
            user.setCreateById(ACCOUNT_ID);
            user.setCreateByName("system");
            user.setCreateTime(new Date());
            addAccounts.add(user);
        }
        // 批量新增用户

        accountService.insertBatch(addAccounts);
    }

    /**
     * 同步组织
     *
     * @param siteCode
     * @param companyId
     * @param companyCode
     * @param orgSelectd
     * @param orgGroups
     * @return
     */
    private boolean syncOrg(String siteCode, Long companyId, String companyCode, Map<String, Long> orgSelectd, Set<String> orgGroups) {
        boolean isNewOrg = false;
        Map<Long, Integer> layerSort = new HashMap<>(); // 每层使用的sort数值
        logger.info("分组的组织信息={}", JSON.toJSONString(orgGroups));
        for (String org : orgGroups) {
            logger.info("未分割的组织信息={}", org);
            String[] orgNameArrays = org.split(SPLIT);
            int arraySize = orgNameArrays.length;
            String mapKey = "";
            // 父组织id
            long parentId = 0;
            long rootId = 0;

            List<Long> orgIdArrays = new ArrayList<>();

            for (int i = 0; i < arraySize; i++) {
                String orgName = orgNameArrays[i];
                logger.info("组织名={}", orgName);
                if (i == 0) {
                    mapKey = orgName;
                } else {
                    mapKey += SPLIT + orgName;
                }
                logger.info("组织key={}", mapKey);
                if (orgSelectd.containsKey(mapKey)) {
                    parentId = orgSelectd.get(mapKey);
                    if (i == 0) {
                        rootId = parentId;
                    }
                    orgIdArrays.add(parentId);
                    continue;
                } else {
                    EntityWrapper<com.yizhi.system.application.domain.Organization> dbOrgEw = QueryUtil.condition(new com.yizhi.system.application.domain.Organization());
                    String[] orgInfo = null;
                    logger.info("orgName.indexOf(SPLIT_S) = "+(orgName.indexOf(SPLIT_S)));
                    if (orgName.indexOf(SPLIT_S) >= 0) {
                        logger.info("存在组织id和组织排序字段");
                        orgInfo = orgName.split(SPLIT_S);
                        dbOrgEw.eq("company_id", companyId).eq("en_name", orgInfo[1]);
                    } else {
                        dbOrgEw.eq("company_id", companyId).eq("name", orgName);
                    }

                    if (parentId > 0) {
                        logger.info("条件={}", parentId);
                        dbOrgEw.eq("parent_id", parentId);
                    }
                    com.yizhi.system.application.domain.Organization dbOrg = organizationService.selectOne(dbOrgEw);
                    logger.info("dbOrg={}", dbOrg);
                    if (dbOrg == null) { // 新增组织
                        isNewOrg = true;
                        long id = idGenerator.generate();
                        dbOrg = new com.yizhi.system.application.domain.Organization();
                        dbOrg.setId(id);
                        String uuid = UUID.randomUUID().toString().replace("_", "");
                        dbOrg.setCode(companyCode + "_" + siteCode + "_" + uuid);

                        dbOrg.setRootId(rootId);
                        dbOrg.setParentId(parentId);
                        if (orgInfo != null) {
                            dbOrg.setEnName(orgInfo[1]);
                            dbOrg.setName(orgInfo[0]);
                            if(orgInfo.length == 3){
                                dbOrg.setSort(Integer.valueOf(orgInfo[2]));
                            }

                        } else {
                            dbOrg.setName(orgName);
                        }
                        dbOrg.setParentIdLayer(orgIdArrays.stream().map(orgIdItem -> orgIdItem.toString()).collect(Collectors.joining("_")));
                        dbOrg.setCompanyId(companyId);
                        int layer = i + 1;
                        dbOrg.setLayer(layer);
                        // 设置排序字段
                        /*if (parentId == 0) {
                            dbOrg.setSort(1);
                        } else {
                            if (layerSort.containsKey(parentId)) {
                                int sortTmp = layerSort.get(parentId) + 1;
                                dbOrg.setSort(sortTmp);
                                layerSort.put(parentId, sortTmp);
                            } else {
                                int dbMaxSort = organizationService.getMaxSort(companyId, parentId) + 1;
                                dbOrg.setSort(dbMaxSort);
                                layerSort.put(parentId, dbMaxSort);
                            }
                        }*/
                        dbOrg.setDeleted(false);
                        dbOrg.setDescription("AUTO_CREATE");
                        dbOrg.setCreateTime(new Date());
                        dbOrg.setCreateById(ACCOUNT_ID);
                        dbOrg.setCreateByName("system");
                        organizationService.insert(dbOrg);
                    } else {
                        if (orgInfo != null) {
                            String dbOrgName = dbOrg.getName();
                            if (!orgInfo[0].equals(dbOrgName) || (orgInfo.length == 3 && !orgInfo[2].equals(dbOrg.getSort()))) {
                                isNewOrg = true;
                                com.yizhi.system.application.domain.Organization dbOrgUp = new com.yizhi.system.application.domain.Organization();
                                dbOrgUp.setId(dbOrg.getId());
                                dbOrgUp.setName(orgInfo[0]);
                                if(orgInfo.length == 3) {
                                    dbOrgUp.setSort(Integer.valueOf(orgInfo[2]));
                                }
                                dbOrgUp.setUpdateById(ACCOUNT_ID);
                                dbOrgUp.setUpdateByName("system");
                                dbOrgUp.setUpdateTime(new Date());
                                organizationService.updateById(dbOrgUp);
                            }
                        }
                    }
                    // 设置每层的id
                    orgIdArrays.add(dbOrg.getId());

                    if (i == 0) {
                        rootId = dbOrg.getId();
                    }
                    parentId = dbOrg.getId();
                    orgSelectd.put(mapKey, dbOrg.getId());
                }
                logger.info("每层级的组织信息={}", JSON.toJSONString(orgIdArrays));
            }
        }
        return isNewOrg;
    }


    /**
     * 更新用户
     *
     * @param syncUserNames
     * @param dbUserNames
     * @param updateUsers
     */
    private String updateUsers(Map<String, OutsideUserVO> syncUserNames, Map<String, OutsideUserVO> dbUserNames, Set<String> updateUsers, Long siteId) {
        String error = "";
        List<com.yizhi.system.application.domain.Account> updateAccounts = new ArrayList<>();
        for (String itemName : updateUsers) {
            OutsideUserVO syncItem = syncUserNames.get(itemName);
            OutsideUserVO dbItem = dbUserNames.get(itemName);

            Long dbSiteId = dbItem.getSiteId();
            if (!siteId.equals(dbSiteId)) {
                error = "同步用户存和其他站点用户信息重复";
                continue;
            }

            boolean updateFlg = false;

            logger.info("请求的用户信息={}", JSON.toJSONString(syncItem));
            logger.info("数据库存在的用户信息={}", JSON.toJSONString(dbItem));

            com.yizhi.system.application.domain.Account upItem = new com.yizhi.system.application.domain.Account();
            upItem.setId(dbItem.getId());

            // 用户名字
            String fullName = syncItem.getFullName();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(fullName)) && !fullName.equals(dbItem.getFullName())) {
                updateFlg = true;
                upItem.setFullName(dbItem.getFullName());
            }

            // 用户在离职状态
            String status = syncItem.getStatus();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(status)) && !status.equals(dbItem.getStatus())) {
                updateFlg = true;
                upItem.setRemarkFirst(status);
                if ("2".equals(status)) {
                    upItem.setEnabled(false);
                } else {
                    upItem.setEnabled(true);
                }
            }

            // 用户组织id
            Long orgId = syncItem.getOrgId();
            if (!orgId.equals(dbItem.getOrgId())) {
                updateFlg = true;
                upItem.setOrgId(orgId);
            }

            // 邮箱
            String email = syncItem.getEmail();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(email)) && !email.equals(dbItem.getEmail())) {
                updateFlg = true;
                upItem.setEmail(email);
            }

            // 手机号码
            String mobile = syncItem.getMobile();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(mobile)) && !mobile.equals(dbItem.getMobile())) {
                updateFlg = true;
                upItem.setMobile(mobile);
            }

            // 工号
            String workNum = syncItem.getWorkNum();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(workNum)) && !workNum.equals(dbItem.getWorkNum())) {
                updateFlg = true;
                upItem.setWorkNum(workNum);
            }

            // 性别（M：男，F:女）
            String sex = syncItem.getSex();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(sex)) && !sex.equals(dbItem.getSex())) {
                updateFlg = true;
                upItem.setSex(sex);
            }

            // 职位
            String position = syncItem.getPosition();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(position)) && !position.equals(dbItem.getPosition())) {
                updateFlg = true;
                upItem.setPosition(position);
            }

            // 身份证号
            String idNumber = syncItem.getIdNumber();
            if (!StringUtils.EMPTY.equals(StringUtils.trimToEmpty(idNumber)) && !idNumber.equals(dbItem.getIdNumber())) {
                updateFlg = true;
                upItem.setIdNumber(idNumber);
            }

            if (updateFlg) {
                upItem.setUpdateById(ACCOUNT_ID);
                upItem.setUpdateByName("system");
                upItem.setUpdateTime(new Date());
                updateAccounts.add(upItem);
            }
        }
        if (!CollectionUtils.isEmpty(updateAccounts)) {
            accountService.updateBatchById(updateAccounts);
        }
        return error;
    }

}
