package com.yizhi.system.application.controller.assember;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.system.application.vo.ContactorVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
 
@Component
public class CompanyAssember {
	@Autowired
	DomainConverter converter;
	public com.yizhi.system.application.domain.Company fromVO(CompanyVO companyVO){
		com.yizhi.system.application.domain.Company company=(com.yizhi.system.application.domain.Company)converter.toDO(companyVO, com.yizhi.system.application.domain.Company.class);
		company.setSuperAdmin((com.yizhi.system.application.domain.Account)converter.toDO(companyVO.getSuperAdmin(), com.yizhi.system.application.domain.Account.class));
		company.setContactors(converter.toDOList(companyVO.getContactorVOs(), com.yizhi.system.application.domain.CompanyContactor.class));
		return company;
	}
	
	public CompanyVO toVO(com.yizhi.system.application.domain.Company company){
		CompanyVO companyVO=(CompanyVO)converter.toVO(company, CompanyVO.class);
		companyVO.setContactorVOs(converter.toVOList(company.getContactors(), ContactorVO.class));
		return companyVO;
	}
	
	public List<CompanyVO> toVOList(List<com.yizhi.system.application.domain.Company> companys){
		List<CompanyVO> voList=new ArrayList<>();
		if(CollectionUtils.isNotEmpty(companys)){			
			for(com.yizhi.system.application.domain.Company company:companys){
				voList.add(toVO(company));
			}
		}
		return voList;
	}
	
	public Page<CompanyVO> toPageVO(Page<com.yizhi.system.application.domain.Company> page){
		Page<CompanyVO> pageVO=new Page<>();
		BeanUtils.copyProperties(pageVO, page);
		pageVO.setRecords(toVOList(page.getRecords()));
		return pageVO;
	}
}
