package com.yizhi.system.application.controller.manage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.page.PageUtil;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.core.application.file.exp.ExcelExportor;
import com.yizhi.core.application.file.imp.AbstractImporter;
import com.yizhi.core.application.file.imp.ImportCallBack;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.core.application.task.TaskHandler;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.constant.CheckPassword;
import com.yizhi.system.application.constant.SystemConstant;
import com.yizhi.system.application.domain.AuthzAccountRole;
import com.yizhi.system.application.domain.AuthzMenu;
import com.yizhi.system.application.exception.AuthNoManagementException;
import com.yizhi.system.application.exception.AuthNotManageException;
import com.yizhi.system.application.model.AccessSite;
import com.yizhi.system.application.model.AccountImpModel;
import com.yizhi.system.application.model.FileUploadModel;
import com.yizhi.system.application.model.ImportModel;
import com.yizhi.system.application.service.*;
import com.yizhi.system.application.util.CollectionUtil;
import com.yizhi.system.application.util.OrgIndexUtil;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.system.application.util.SignUtil;
import com.yizhi.system.application.vo.*;
import com.yizhi.system.application.vo.domain.Account;
import com.yizhi.system.application.vo.domain.AuthzRole;
import com.yizhi.system.application.vo.domain.Organization;
import com.yizhi.util.application.clazz.ClassUtil;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.domain.BizResponse;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.httpclient.HttpClientUtils;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.sm2.SM2_NEW;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.wechat.application.feign.WeiXinClient;
import com.yizhi.wechat.application.vo.wechat.domain.TrAccountUserinfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.*;
import java.util.stream.Collectors;

import static com.yizhi.system.application.constant.CommunityParams.*;

@Api(tags = "账号管理接口")
@RestController
@RequestMapping(value = "/manage/account")
public class AccountController {

    @Autowired
    IAccountService accountService;
    @Autowired
    private AuthService authService;
    @Autowired
    DomainConverter converter;
    @Autowired
    TaskExecutor executor;
    @Autowired
    LogEventPublisher eventPublisher;
    /*@Autowired
    AmqpTemplate rabbitTemplate;*/
    @Autowired
    ISiteService siteService;
    @Autowired
    AuthorityService authorityService;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    LogEventPublisher publisher;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    TaskExecutor taskExecutor;
    @Autowired
    private IAuthzRoleService roleService;
    @Autowired
    private IAuthzUserGroupService groupService;
    @Autowired
    private ICompanyService companyService;
    @Autowired
    private IAuthzGroupMemberService authzGroupMemberService;

    @Autowired
    private IAccountImportService accountImportService;

    @Autowired
    private WeiXinClient weiXinClient;

    @Autowired
    private IAuthzAccountRoleService authzAccountRoleService;

    @Value("${community.get.token.location}")
    private String LOCATION;

    private static final Logger logger = LoggerFactory.getLogger(AccountController.class);

    /**
     * 新增账号
     *
     * @param accountVO
     * @return
     */
    @ApiOperation(value = "新增账号", notes = "新增账号")
    @PostMapping(value = "/add")
    public Response<String> addAccount(@RequestBody AccountRegisterVO accountVO) {
        try {
            com.yizhi.system.application.domain.Account account = (com.yizhi.system.application.domain.Account) converter.toDO(accountVO, com.yizhi.system.application.domain.Account.class);
            account.setCompanyId(ContextHolder.get().getCompanyId());
            accountService.add(account);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 更新账号密码
     *
     * @param authVO
     * @return
     */
    @ApiOperation(value = "修改密码", notes = "修改密码")
    @PostMapping(value = "/update/password")
    public Response<String> updatePassword(@RequestBody AccountRegisterVO authVO) {
        try {
            SortedMap<String, String> sugMap = new TreeMap<String, String>();
            sugMap.put("id", String.valueOf(authVO.getId()));
            sugMap.put("sign", authVO.getSign());
            sugMap.put("password", authVO.getPassword());
            sugMap.put("salt", authVO.getSalt());
            boolean correctSign = SignUtil.isCorrectSign(sugMap, authVO.getSalt());
            if (!correctSign) {
                //临时注释
//	            return Response.fail(ReturnCode.SIGN_FAIL.getCode(), ReturnCode.SIGN_FAIL.getMsg());
            }
            Long id = Long.parseLong(SM2_NEW.decryptWithSalt(authVO.getId()));
            String decryptNewPwd = SM2_NEW.decryptWithSalt(authVO.getPassword());
            com.yizhi.system.application.domain.Account account = accountService.selectById(id);
            if (account == null) {
                return Response.fail(ReturnCode.ACCOUNT_NOT_EXIST.getCode(), ReturnCode.ACCOUNT_NOT_EXIST.getMsg());
            }
            if (StringUtils.isNotBlank(decryptNewPwd)) {
                // 新密码规则
                if (!CheckPassword.checkPasswordRule(decryptNewPwd, account.getName())) {
                    return Response.fail(Constants.NON_COMPLIANT_PASSWORD.getCode().toString(), Constants.NON_COMPLIANT_PASSWORD.getName());
                }
                accountService.updatePassword(account.getId(), decryptNewPwd);
            } else {
                return Response.fail(Constants.SYSTEM_MSG_PWD_EMPTY.getCode().toString(), Constants.SYSTEM_MSG_PWD_EMPTY.getName());
            }

        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 禁止账号
     *
     * @param logVO
     * @return
     */
    @ApiOperation(value = "禁用账号", notes = "禁用账号")
    @PostMapping(value = "/close")
    public Response<String> closeAccount(@RequestBody AccountEnableLogVO logVO) {
        try {
            logVO.setType(2);
            accountService.close((com.yizhi.system.application.domain.AccountEnableLog) converter.toDO(logVO, com.yizhi.system.application.domain.AccountEnableLog.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 开通账号
     *
     * @param logVO
     * @return
     */
    @ApiOperation(value = "开通账号", notes = "开通账号")
    @PostMapping(value = "/open")
    public Response<String> openAccount(@RequestBody AccountEnableLogVO logVO) {
        try {
            logVO.setType(1);
            accountService.open((com.yizhi.system.application.domain.AccountEnableLog) converter.toDO(logVO, com.yizhi.system.application.domain.AccountEnableLog.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 更新账号
     *
     * @param accountVO
     * @return
     */
    @ApiOperation(value = "更新账号", notes = "更新账号")
    @PostMapping(value = "/update")
    public Response<String> updateAccount(@RequestBody AccountVO accountVO) {
        try {
            accountService.update((com.yizhi.system.application.domain.Account) converter.toDO(accountVO, com.yizhi.system.application.domain.Account.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 根据账号id查询账号信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "获取账号", notes = "获取账号")
    @GetMapping(value = "/get")
    public Response<AccountVO> findById(@RequestParam(required = true) Long id) {
        try {
            AccountVO accountVO = (AccountVO) converter.toVO(accountService.get(id), AccountVO.class);
            return Response.ok(accountVO);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 查询账号所有的角色列表
     *
     * @param accountId
     * @return
     */
    @ApiOperation(value = "查找账号角色列表", notes = "查找账号角色列表")
    @GetMapping(value = "/list/role")
    public Response<List<AuthzRole>> findRoles(@RequestParam(required = true) Long accountId) {
        try {
            return Response.ok(accountService.findRoles(accountId));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 根据账号id查询账号信息
     *
     * @param name
     * @return
     */
    @ApiOperation(value = "检查账号名称是否存在", notes = "检查账号名称是否存在")
    @GetMapping(value = "/name/check")
    public Response<String> checkName(@RequestParam(required = true) String name) {
        try {
            accountService.nameExists(0L, ContextHolder.get().getCompanyId(), name);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 获取站点下账号
     *
     * @param siteId
     * @return
     */
    @ApiOperation(value = "根据站点id查找所有用户", notes = "根据站点id查找所有用户")
    @GetMapping(value = "/list/site")
    public Response<AccountVO> getAccountBySiteId(@RequestParam Long siteId) {
        try {
            return Response.ok(converter.toDOList(accountService.selectBySiteId(siteId), AccountVO.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 获取站点下账号
     *
     * @param keyword
     * @return
     */
    @ApiOperation(value = "查找站点下所有用户", notes = "查找站点下所有用户，用户名、姓名、手机号")
    @GetMapping(value = "/list/site/keyword")
    public Response<Account> getAccountBySiteId(@RequestParam(name = "keyword", required = false) String keyword,
                                                @RequestParam(name = "pageNo", defaultValue = "1") int pageNo,
                                                @RequestParam(name = "pageSize", defaultValue = "50") int pageSize) {
        try {
            Long siteId = ContextHolder.get().getSiteId();
            Long companyId = ContextHolder.get().getCompanyId();

            com.yizhi.system.application.domain.Company company = companyService.selectById(companyId);
            com.yizhi.system.application.domain.Site site = siteService.selectById(siteId);

            boolean allCompanyRange = false;
            List<RightLeftIndex> indices = null;
            List<Long> accountIds = new ArrayList<>();

            // 1.1 如果是主站点，查询所有企业下的用户
            if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
                allCompanyRange = true;
            }
            // 1.2 否则是子站点，子站点下的部门包含根部门，则 查询所有企业下的用户
            else {
                Organization rootOrg = getRootOrg(company.getId());
                Set<Long> siteOrgIds = authzGroupMemberService.getMemberIdByGroupIdAndType(site.getUserGroupId(), 1);
                if (!org.springframework.util.CollectionUtils.isEmpty(siteOrgIds) && siteOrgIds.contains(rootOrg.getId())) {
                    allCompanyRange = true;
                }
                // 1.3 否则查询子站点下部门
                else {
                    Set<Long> accountIdSet = authzGroupMemberService.getMemberIdByGroupIdAndType(site.getUserGroupId(), 2);
                    if (!org.springframework.util.CollectionUtils.isEmpty(accountIdSet)) {
                        accountIds = new ArrayList<>();
                        accountIds.addAll(accountIdSet);
                    }
                    if (!org.springframework.util.CollectionUtils.isEmpty(siteOrgIds)) {
                        indices = OrgIndexUtil.getChildrenRange(organizationService.selectBatchIds(siteOrgIds));
                    }
                }
            }
            Page<com.yizhi.system.application.domain.Account> page = new Page<>(pageNo, pageSize);
            page.setRecords(accountService.getByParam(company.getId(), true, keyword, keyword, indices, accountIds, page));
            return Response.ok(page);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }


    /**
     * @param orgName
     * @return
     */
    @ApiOperation(value = "根据部门名称模糊查找所有用户", notes = "根据部门名称模糊查找所有用户")
    @GetMapping(value = "/list/org")
    public Response<List<AccountVO>> getAccountByOrgName(@RequestParam String orgName) {
        try {
            return Response.ok(converter.toDOList(
                    accountService.getAccountByOrgName(orgName, ContextHolder.get().getCompanyId()), AccountVO.class));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 批量修改部门
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "批量修改部门", notes = "批量修改部门")
    @PostMapping(value = "/update/org/batch")
    public Response<String> batchUpdateOrg(@RequestBody BatchAdjustVO vo) {
        try {
            accountService.batchUpdateOrg(vo.getAccountIds(), vo.getOrgId());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 批量解绑微信
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "批量解绑微信", notes = "批量解绑微信")
    @PostMapping(value = "/delete/chat/batch")
    public Response<String> batchDeleteWechat(@RequestBody BatchAdjustVO vo) {
        try {
            accountService.batchDeleteWechat(vo.getAccountIds());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 批量禁用账号
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "批量禁用账号", notes = "批量禁用账号")
    @PostMapping(value = "/disable/batch")
    public Response<String> batchDisable(@RequestBody BatchAdjustVO vo) {
        try {
            accountService.batchDisable(vo.getAccountIds());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 根据多个名字组成的串查询账号
     *
     * @param vo
     * @return
     */
    @ApiOperation(value = "根据多个名字组成的串查询账号", notes = "根据多个名字组成的串查询账号")
    @PostMapping(value = "/list/names")
    public Response<AccountVO> listByNames(@RequestBody AccountNamesVO vo) {
        // 参数检查
        if (null == vo || StringUtils.isEmpty(vo.getNames())) {
            return Response.fail("4001", "检索参数为空");
        }

        List<AccountVO> accountVOs = null;
        try {
            RequestContext context = ContextHolder.get();
            List<RightLeftIndex> rightLeftIndices = new ArrayList<>();
            List<Long> userGroupIds = new ArrayList<>();
            List<com.yizhi.system.application.domain.Account> result;
            boolean noRange = false;

            com.yizhi.system.application.domain.Site site = siteService.selectById(context.getSiteId());
            noRange = buildListAccountAuthzRange(context, site, noRange, rightLeftIndices, userGroupIds,
                    SystemConstant.TYPE_SYSTEM);

            List<String> names = new ArrayList<>();
            for (String name : vo.getNames().split(";")) {
                names.add(name);
            }
            result = accountService.listByNamesInManageRange(names, noRange, rightLeftIndices, userGroupIds,
                    context.getCompanyId(), vo.getType());

            if (!CollectionUtils.isEmpty(result)) {
                List<AccountVO> accountVOS = null;
                accountVOS = converter.toVOList(result, AccountVO.class);
                return Response.ok(accountVOS);
            }
            return Response.ok();
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "搜索用户", response = AccountVO.class)
    @GetMapping(value = "/name/search")
    public Response<List<AccountVO>> listByNames(
            @ApiParam(value = "要查询的账号名称") @RequestParam("seachVal") String seachVal,
            @ApiParam(value = "所属组织id，系统管理用，非必传") @RequestParam(name = "orgId", required = false) Long orgId,
            @ApiParam(value = "所属管辖区id，系统管理用，非必传") @RequestParam(name = "userGroupId", required = false) Long userGroupId,
            @ApiParam(value = "业务发起类型,</br>" + "课程：course</br>" + "证书：certificate</br>" + "考试：exam</br>"
                    + "调研：research</br>" + "投票：vote</br>" + "做课：lesson</br>" + "学习营销：marketingCourse</br>"
                    + "直播：live</br>" + "作业：assignment</br>" + "项目：trainingProject</br>" + "消息：message</br>"
                    + "banner：banner</br>" + "积分：point</br>" + "站点：site</br>"
                    + "系统：system</br>") @RequestParam("type") String type) {
        try {
            RequestContext context = ContextHolder.get();
            List<RightLeftIndex> rightLeftIndices = new ArrayList<>();
            List<Long> userGroupIds = new ArrayList<>();
            List<com.yizhi.system.application.domain.Account> result;
            Boolean noRange = true;

            com.yizhi.system.application.domain.Site site = siteService.selectById(context.getSiteId());

           // noRange = buildListAccountAuthzRangeNew(context, site, noRange, rightLeftIndices, userGroupIds, type);

            List<String> names = new ArrayList<>();
            if (StringUtils.isNotEmpty(seachVal)) {
                names.add(seachVal);
            }
            result = accountService.listByNamesInManageRange(names, noRange, rightLeftIndices, userGroupIds,
                    context.getCompanyId(), null);

            if (!CollectionUtils.isEmpty(result)) {
                List<AccountVO> accountVOS;
                accountVOS = converter.toVOList(result, AccountVO.class);
                return Response.ok(accountVOS);
            }
            return Response.ok();
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(e.getLocalizedMessage());
        }
    }

    /**
     * 批量导入账号
     *
     * @param model
     * @return
     */
    @ApiOperation(value = "批量导入账号", notes = "批量导入账号")
    @PostMapping(value = "/import")
    public Response<String> importAccounts(@RequestBody FileUploadModel model) {
        logger.info("导入文件信息=====" + JSON.toJSONString(model));
        String taskLogSerialNo = "USER-" + DateUtil.getYMDHMSS();
        try {
            Long taskId = idGenerator.generate();
            RequestContext context = ContextHolder.get();
            Long companyId = context.getCompanyId();
            Long siteId = context.getSiteId();
            Long accountId = context.getAccountId();
            TaskContext taskContext = new TaskContext(taskId, taskLogSerialNo, "批量导入用户", accountId, new Date(), siteId,
                    companyId);
            ImportModel importModel = (ImportModel) converter.toDO(context, ImportModel.class);
            importModel.setTaskId(taskId);
            ImportCallBack callBack = new ImportCallBack() {
                @Override
                public Boolean exec(TaskHandler taskHandler, List dataObjs) {
                    importModel.setData(dataObjs);
                    List<AccountImpModel> models = accountImportService.importAccount(importModel, context);
                    // 所有的信息要上传到oss服务器
                    ExcelForAccountImportExporter<AccountImpModel> exporter = new ExcelForAccountImportExporter<>(
                            createExpTemplate(), models);
                    exporter.bindContext(taskContext);
                    exporter.bindPublisher(publisher);
                    exporter.handle();
                    return true;
                }
            };
            AbstractImporter importer = AbstractImporter.build(model.getFileUrl(), null, model.getFileName(), callBack,
                    createImpTemplate(), AccountImpModel.class);
            importer.bindContext(taskContext);
            importer.bindPublisher(publisher);
            taskExecutor.asynExecute(importer);
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok(taskLogSerialNo);
    }

    /**
     * 查询账号列表
     *
     * @param name
     * @param mobile
     * @return
     */
    @ApiOperation(value = "组织下人员接口-其他 -- 权限改造", response = AccountVO.class)
    @GetMapping("/other/list")
    public Response<PageInfo<AccountVO>> list(
            @ApiParam("管辖区id") @RequestParam(name = "groupId", required = false) Long groupId,
            @ApiParam("用户名、姓名") @RequestParam(name = "name", required = false) String name,
            @ApiParam("手机") @RequestParam(name = "mobile", required = false) String mobile,
            @ApiParam("工号") @RequestParam(name = "workNum", required = false) String workNum,
            @ApiParam("邮箱") @RequestParam(name = "email", required = false) String email,
            @ApiParam("状态：1启用,0停用") @RequestParam(name = "enabled", required = false) Integer enabled,
            @ApiParam("当前页数") @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam("每页条数") @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        try {
            Page<com.yizhi.system.application.domain.Account> page = accountService.orgAccountListPageOther(groupId, name, mobile, workNum, email, enabled,
                    pageNo, pageSize);

            List<com.yizhi.system.application.domain.Account> accounts = page.getRecords();
            judgeBindWeChat(accounts);
            return Response.ok(PageUtil.versa(converter.toPageVO(page, AccountVO.class)));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 判断是否绑定了微信
     * @param accounts
     */
    private void judgeBindWeChat(List<com.yizhi.system.application.domain.Account> accounts){
        if (CollectionUtils.isNotEmpty(accounts)) {
            // 判断是否绑定微信
            List<Long> accountIds = accounts.parallelStream().map(account -> {
                return account.getId();
            }).collect(Collectors.toList());
            com.yizhi.wechat.application.vo.wechat.AuthorizeUsersVO authorizeUsersVO = new com.yizhi.wechat.application.vo.wechat.AuthorizeUsersVO();
            authorizeUsersVO.setUserIds(accountIds);
            authorizeUsersVO.setRoleId(ContextHolder.get().getCompanyId());
            Map<Long, TrAccountUserinfoVo> userRelations = null;
            try {
                userRelations = weiXinClient.getUserRelations(authorizeUsersVO);
            } catch (Exception e) {
                e.printStackTrace();
                logger.info("查询绑定微信的关系异常");
            }
            if (userRelations == null) {
                return;
            }
            logger.info("绑定微信的关系：{}", userRelations);
            Map<Long, TrAccountUserinfoVo> finalUserRelations = userRelations;
            accounts = accounts.parallelStream().map(account -> {
                account.setBindWeChat(finalUserRelations.get(account.getId()) != null ? Boolean.TRUE : Boolean.FALSE);
                return account;
            }).collect(Collectors.toList());
        }
    }

    @ApiOperation(value = "组织下人员接口-部门 -- 权限改造", response = AccountVO.class)
    @GetMapping("/list")
    public Response<PageInfo<AccountVO>> orgAccountListPage(
            @ApiParam("部门id") @RequestParam(value = "orgId", required = false) Long orgId,
            @ApiParam("用户名、姓名") @RequestParam(name = "name", required = false) String name,
            @ApiParam("手机") @RequestParam(name = "mobile", required = false) String mobile,
            @ApiParam("工号") @RequestParam(name = "workNum", required = false) String workNum,
            @ApiParam("邮箱") @RequestParam(name = "email", required = false) String email,
            @ApiParam("状态：1启用,0停用") @RequestParam(name = "enabled", required = false) Integer enabled,
            @ApiParam("当前页数") @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
            @ApiParam("每页条数") @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize) {
        try {
            RequestContext context = ContextHolder.get();
            logger.info("上下文信息：{}", JSON.toJSON(context));
            Boolean noRange = false;
            List<RightLeftIndex> rightLeftIndices = null;
            // 部门下人员分页接口
            if (null != orgId) {
                // 如果是根组织，查询整个企业的
                com.yizhi.system.application.domain.Organization organization = organizationService.selectById(orgId);
                if (organization.getCode().indexOf(AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX) != -1) {
                    noRange = true;
                }
                // 不是根组织，查询当前组织及以下的
                else {
                    rightLeftIndices = (List<RightLeftIndex>) CollectionUtil.getArrayList(
                            new RightLeftIndex(organization.getLeftIndex(), organization.getRightIndex()));
                }
            }
            // 否则，是搜索（当前站点内的所有）
            else {
                // 如果是默认站点，并且是站点管理员，查询整个企业的
                com.yizhi.system.application.domain.Site site = siteService.selectById(context.getSiteId());
                if (site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT) && context.isAdmin()) {
                    noRange = true;
                }
                // 查询管辖范围内的
                else {
                    // 如果是站点管理员，查询整个站点的 --> 站点管辖区下的部门
                    if (context.isAdmin()) {
                        rightLeftIndices = organizationService.getOrgRangeByGroupId(site.getUserGroupId());
                    }
                    // 如果是业务管理员，查询用户管理角色下的 管辖区 关联的部门
                    else {
                        List<Long> roleIds = roleService.getIdByModuleCodeInSite(context.getCompanyId(),
                                context.getSiteId(), context.getAccountId(), SystemConstant.TYPE_SYSTEM);
                        Set<Long> userGroupIds = groupService.getByRoleId(roleIds);
                        if (CollectionUtils.isNotEmpty(userGroupIds)) {
                            Long[] ids = new Long[userGroupIds.size()];
                            int index = -1;
                            for (Long id : userGroupIds) {
                                index++;
                                ids[index] = id;
                            }
                            rightLeftIndices = organizationService.getOrgRangeByGroupId(ids);
                        }
                    }
                }
            }

            Page<com.yizhi.system.application.domain.Account> page = null;
            // 查询所有企业内的
            if (noRange) {
                com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
                account.setCompanyId(context.getCompanyId());
                if (null != enabled) {
                    account.setEnabled(enabled.equals(1) ? true : false);
                }
                EntityWrapper ew = new EntityWrapper(account);
                if (StringUtils.isNotEmpty(name)) {
                    ew.like("name", name.trim()).or().like("full_name", name.trim()).or().like("mobile", name.trim())
                            .or().like("work_num", name.trim());
                }
                if(null != orgId){
                    ew.eq("org_id",orgId);
                }
                page = accountService.selectPage(new Page<>(pageNo, pageSize), ew);

            }
            // 查询管辖范围内的
            else if (!CollectionUtils.isEmpty(rightLeftIndices)) {
                page = accountService.orgAccountListPage(context.getCompanyId(), rightLeftIndices, name, mobile,orgId,
                        workNum, name, email, enabled, pageNo, pageSize);
            }

            if (page != null) {
                List<com.yizhi.system.application.domain.Account> accounts = page.getRecords();
                if (CollectionUtils.isNotEmpty(accounts)) {
                    // 判断是否绑定微信
                    List<Long> accountIds = accounts.parallelStream().map(com.yizhi.system.application.domain.Account::getId).collect(Collectors.toList());
                    // 根据用户ID集合查询角色集合
                    List<AuthzAccountRole> authzAccountRoleList = authzAccountRoleService.getRoleIdsByAccountIds(accountIds);
                    if (CollectionUtils.isNotEmpty(authzAccountRoleList)) {
                        // 组装角色ID集合
                        List<Long> roleIdList = authzAccountRoleList.stream().map(AuthzAccountRole::getRoleId).collect(Collectors.toList());
                        // 根据角色ID集合查询角色名称
                        List<com.yizhi.system.application.domain.AuthzRole> authzRoles =roleService.selectBatchIds(roleIdList);
                        if (CollectionUtils.isNotEmpty(authzRoles)) {
                            // 根据accountId找到关联的角色名称，用逗号分割封装到用户对象中relationRoleNames字段
                            accounts = accounts.parallelStream().map(account -> {
                                List<String> roleNames = authzRoles.stream().filter(authzRole -> authzAccountRoleList.stream().filter(authzAccountRole -> authzAccountRole.getAccountId().equals(account.getId())).map(AuthzAccountRole::getRoleId).collect(Collectors.toList()).contains(authzRole.getId())).map(com.yizhi.system.application.domain.AuthzRole::getName).collect(Collectors.toList());
                                account.setRelationRoleNames(StringUtils.join(roleNames, ","));
                                return account;
                            }).collect(Collectors.toList());
                        }
                    }
                    com.yizhi.wechat.application.vo.wechat.AuthorizeUsersVO authorizeUsersVO = new com.yizhi.wechat.application.vo.wechat.AuthorizeUsersVO();
                    authorizeUsersVO.setUserIds(accountIds);
                    authorizeUsersVO.setRoleId(context.getCompanyId());
                    Map<Long, TrAccountUserinfoVo> userRelations = weiXinClient.getUserRelations(authorizeUsersVO);
                    logger.info("绑定微信的关系：{}", userRelations);
                    accounts = accounts.parallelStream().map(account -> {
                        if (userRelations.get(account.getId()) != null) {
                            account.setBindWeChat(Boolean.TRUE);
                            account.setWechat(userRelations.get(account.getId()).getWechatuserid());
                        } else {
                            account.setBindWeChat(Boolean.FALSE);
                            account.setWechat("");
                        }
                        return account;
                    }).collect(Collectors.toList());
                    page.setRecords(accounts);
                }
                return Response.ok(PageUtil.versa(converter.toPageVO(page, AccountVO.class)));
            } else {
                return Response.ok(new PageInfo<>());
            }

        } catch (Exception e) {
            logger.error("", e);
            return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(), ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 查询下组织下所有的人员
     *
     * @param companyId
     * @param orgId
     * @param pageNo
     * @param pageSize
     * @return
     */
    public List<com.yizhi.system.application.domain.Account> findAccountListByOrgId(
            Long companyId,
            Long orgId,
            Integer pageNo,
            Integer pageSize) {
        Boolean noRange = false;
        List<RightLeftIndex> rightLeftIndices = null;
        // 部门下人员分页接口
        if (null != orgId) {
            // 如果是根组织，查询整个企业的
            com.yizhi.system.application.domain.Organization organization = organizationService.selectById(orgId);
            if (organization.getCode().indexOf(AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX) != -1) {
                noRange = true;
            } else {
                // 不是根组织，查询当前组织及以下的
                rightLeftIndices = (List<RightLeftIndex>) CollectionUtil.getArrayList(
                        new RightLeftIndex(organization.getLeftIndex(), organization.getRightIndex()));
            }
        }
        Page<com.yizhi.system.application.domain.Account> page = null;
        // 查询所有企业内的
        if (noRange) {
            Account account = new Account();
            account.setCompanyId(companyId);
            account.setEnabled(true);
            EntityWrapper ew = new EntityWrapper(account);
            page = accountService.selectPage(new Page<>(pageNo, pageSize), ew);
        }
        // 查询管辖范围内的
        else if (!CollectionUtils.isEmpty(rightLeftIndices)) {
            page = accountService.orgAccountListById(companyId, rightLeftIndices, null, null,null,
                    null, null, null, 1, pageNo, pageSize);
        }
        // 获取用组织下所有的用户id
        logger.info("返回组织下所有用户：{}", JSON.toJSON(page));
        if (CollectionUtils.isNotEmpty(page.getRecords())) {
            return page.getRecords();
        } else {
            return Collections.emptyList();
        }
    }

    private Template createImpTemplate() {
        Template template = new Template();
        List<TemplateColumn> columns = new ArrayList<>();
        columns.add(new TemplateColumn("name", "用户名", 1));
        columns.add(new TemplateColumn("newName", "新用户名", 2));

        columns.add(new TemplateColumn("password", "密码", 3));
        columns.add(new TemplateColumn("worknum", "工号", 4));
        columns.add(new TemplateColumn("fullName", "姓名", 5));
        columns.add(new TemplateColumn("position", "职务", 6));
        columns.add(new TemplateColumn("fullOrgName", "所在部门", 7));
//        columns.add(new TemplateColumn("orgCode", "部门编码", 6));
        columns.add(new TemplateColumn("mobile", "手机号", 87));
        columns.add(new TemplateColumn("email", "邮箱", 9));
//        columns.add(new TemplateColumn("wechat", "微信号", 9));

        columns.add(new TemplateColumn("remarkFirst", "备注1", 10));
        columns.add(new TemplateColumn("remarkSecond", "备注2", 11));
        columns.add(new TemplateColumn("remarkThird", "备注3", 12));

        columns.add(new TemplateColumn("validDate", "有效期", 13));
        columns.add(new TemplateColumn("enabled", "启用/停用", 14));
        columns.add(new TemplateColumn("operation", "操作", 15));
        template.setColumns(columns);
        return template;
    }

    private Template createExpTemplate() {
        Template template = createImpTemplate();
        List<TemplateColumn> columns = template.getColumns();
        columns.add(new TemplateColumn("result", "结果", 15));
        template.setColumns(columns);
        template.setBrowserExport(false);
        return template;
    }

    private boolean buildListAccountAuthzRange(RequestContext context, com.yizhi.system.application.domain.Site site, boolean noRange,
                                               List<RightLeftIndex> rightLeftIndices, List<Long> userGroupIds, String type) {
        // 如果是站点管理员 并且 是默认站点
        if (context.isAdmin() && site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
            noRange = true;
        }
        // 如果是站点管理员 并且 不是默认站点
        else if (context.isAdmin() && site.getType().equals(AuthzConstant.SITE_TYPE_SUB)) {
            // 1.1 查询出该站点下管理的部门
            List<RightLeftIndex> groupIds = organizationService.getOrgRangeByGroupId(site.getUserGroupId());
            rightLeftIndices.addAll(groupIds == null ? new ArrayList<>() : groupIds);
            userGroupIds.add(site.getUserGroupId());
        }
        // 不是站点管理员，那就是业务管理员
        else {
            List<Long> roleIds = roleService.getIdByModuleCodeInSite(context.getCompanyId(), context.getSiteId(),
                    context.getAccountId(), type);
            Set<Long> byRoleId = groupService.getByRoleId(roleIds);
            userGroupIds.addAll(byRoleId == null ? new ArrayList<>() : byRoleId);
            if (CollectionUtils.isNotEmpty(userGroupIds)) {
                Long[] ids = new Long[userGroupIds.size()];
                int index = -1;
                for (Long id : userGroupIds) {
                    index++;
                    ids[index] = id;
                }
                List<RightLeftIndex> indices = organizationService.getOrgRangeByGroupId(ids);
                if (CollectionUtils.isNotEmpty(indices)) {
                    rightLeftIndices.addAll(indices);
                }
            }
        }
        return noRange;
    }

    /**
     * copy  buildListAccountAuthzRange
     * 只是由 getOrgRangeByGroupId 改为getOrgRangeByGroupIdNew
     * @param context
     * @param site
     * @param noRange
     * @param rightLeftIndices
     * @param userGroupIds
     * @param type
     * @return
     */
    private boolean buildListAccountAuthzRangeNew(RequestContext context, com.yizhi.system.application.domain.Site site, boolean noRange,
                                               List<RightLeftIndex> rightLeftIndices, List<Long> userGroupIds, String type) {
        // 如果是站点管理员 并且 是默认站点
        if (context.isAdmin() && site.getType().equals(AuthzConstant.SITE_TYPE_DEFAULT)) {
            noRange = true;
        }
        // 如果是站点管理员 并且 不是默认站点
        else if (context.isAdmin() && site.getType().equals(AuthzConstant.SITE_TYPE_SUB)) {
            // 1.1 查询出该站点下管理的部门
            List<RightLeftIndex> groupIds = organizationService.getOrgRangeByGroupId(site.getUserGroupId());
            rightLeftIndices.addAll(groupIds == null ? new ArrayList<>() : groupIds);
            userGroupIds.add(site.getUserGroupId());
        }
        // 不是站点管理员，那就是业务管理员
        else {
            List<Long> roleIds = roleService.getIdByModuleCodeInSite(context.getCompanyId(), context.getSiteId(),
                    context.getAccountId(), type);
            Set<Long> byRoleId = groupService.getByRoleId(roleIds);
            userGroupIds.addAll(byRoleId == null ? new ArrayList<>() : byRoleId);
            if (CollectionUtils.isNotEmpty(userGroupIds)) {
                Long[] ids = new Long[userGroupIds.size()];
                int index = -1;
                for (Long id : userGroupIds) {
                    index++;
                    ids[index] = id;
                }
                //此处应获取当前用户所关联角色下的 管辖区 关联的部门的并集
                List<RightLeftIndex> indices = organizationService.getOrgRangeByGroupIdNew(ids);
                if (CollectionUtils.isNotEmpty(indices)) {
                    rightLeftIndices.addAll(indices);
                }
            }
        }
        return noRange;
    }

    class ExcelForAccountImportExporter<T> extends ExcelExportor<T> {

        public ExcelForAccountImportExporter(Template template, List data) {
            super(template, data);
        }

        @Override
        public FileInfo render() {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFileType(template.getFileType());
            // 创建HSSFWorkbook对象(excel的文档对象)
            HSSFWorkbook wb = new HSSFWorkbook();
            // 建立新的sheet对象（excel的表单）
            HSSFSheet sheet = wb.createSheet();
            // 在sheet里创建第一行，标题行
            HSSFRow row1 = sheet.createRow((int) 0);
            // 标题目录
            List<TemplateColumn> columns = template.getColumns();
            for (int i = 0; i < columns.size(); i++) {
                Cell cell = row1.createCell(i);
                cell.setCellValue(columns.get(i).getColumnName().toString());
            }
            // 行数据
            HSSFRow row2 = null;
            int passCount = 0;
            int failCount = 0;
            if (CollectionUtils.isNotEmpty(data)) {
                for (int j = 0; j < data.size(); j++) {
                    T t = data.get(j);
                    row2 = sheet.createRow((int) j + 1);
                    for (int m = 0; m < columns.size(); m++) {
                        TemplateColumn templateColumn = columns.get(m);
                        String cellValue = ClassUtil.invokeMethod(t, templateColumn.getColumn()).toString();
                        row2.createCell(m).setCellValue(cellValue);
                    }
                    if (StringUtils.isNotEmpty(
                            ClassUtil.invokeMethod(t, columns.get(columns.size() - 1).getColumn()).toString())) {
                        failCount++;
                    } else {
                        passCount++;
                    }
                }
            }
            String fileName = template.getFileName();
            if (StringUtils.isEmpty(fileName)) {
                fileName = "导出文件".concat(String.valueOf(System.currentTimeMillis())).concat(".xls");
            }
            fileInfo.setFileName(fileName);
            if (template.getBrowserExport()) {
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
                response.setContentType("application/vnd.ms-excel");
                OutputStream output = null;
                try {
                    output = response.getOutputStream();
                    wb.write(output);
                    output.flush();
                    publishTaskEvent(TaskLogEvent.success(taskContext, "导入成功", null));
                } catch (IOException e) {
                    publishTaskEvent(TaskLogEvent.fail(taskContext, "文件导入异常:" + e.getMessage()));
                    logger.error("文件导入异常", e);
                } finally {
                    try {
                        output.close();
                    } catch (IOException e) {
                        logger.error("文件导入关闭流异常", e);
                    }
                }
            } else {
                String path = new StringBuffer().append(FileConstant.SAVE_PATH).append(File.separator).append(fileName)
                        .toString();
//	    	//文件保存位置
                File saveDir = new File(FileConstant.SAVE_PATH);
                if (!saveDir.exists()) {
                    saveDir.mkdir();
                }
                File file = new File(saveDir + File.separator + fileName);
                try {
                    FileOutputStream os = new FileOutputStream(file);
                    wb.write(os);
                    os.close();
                    // 阿里云返回url
                    String upLoadUrl = OssUpload.upload(path, fileName);// path, fileName
                    publishTaskEvent(TaskLogEvent.success(taskContext, "成功导入" + passCount + "条，失败" + failCount + "条",
                            upLoadUrl));
                    file.delete();
                } catch (Exception e) {
                    publishTaskEvent(TaskLogEvent.fail(taskContext, "写入过程中发生错误:" + e.getMessage()));
                    logger.error("写入过程中发生错误", e);
                }
            }
            return fileInfo;
        }
    }

    @GetMapping("/idName")
    public List<com.yizhi.system.application.domain.Account> accountList(@RequestParam(name = "companyId", required = true) Long companyId,
                                                                         @RequestParam(name = "ids", required = false) List<Long> ids) {
        return accountService.getAccountsByCompanIdIds(companyId, ids);
    }

    /**
     * 获取企业下根部门
     *
     * @param companyId
     * @return
     */
    private Organization getRootOrg(long companyId) {
        com.yizhi.system.application.domain.Organization rootOrg = new com.yizhi.system.application.domain.Organization();
        rootOrg.setCompanyId(companyId);
        rootOrg.setDeleted(false);
        rootOrg.setParentId(0L);
        rootOrg = rootOrg.selectOne(new EntityWrapper(rootOrg));
        Organization organization = new Organization();
        BeanUtils.copyProperties(rootOrg, organization);
        return organization;
    }

//    @Autowired
//    private JavaMailSender mailSender;
//
//    @ApiOperation(value = "发邮件", notes = "发邮件")
//	@GetMapping(value = "sendMail")
//	public void sendEmail(){
//        SimpleMailMessage message = new SimpleMailMessage();
//        message.setFrom("gwdx-app@atc.sgcc.com.cn");
//        message.setTo("466139676@qq.com");
//        message.setSubject("主题密码");
//        message.setText("当前发送内容！");
//
//        mailSender.send(message);
//    }

    @ApiOperation(value = "获取访问社群的accessToken")
    @GetMapping("/access/community")
    public BizResponse list() throws AuthNotManageException, AuthNoManagementException {
        RequestContext context = ContextHolder.get();
        List<AccessSite> accessSites = authService.getAccessSiteWithMenu(context.getCompanyCode(), context.getAccountId(), context.getSiteId());
        //当前用户所关联的角色管理了社群菜单才可以访问，否则禁止访问
        judgeWhetherIsCommunityManager(context, accessSites);
        if (!context.getIsCommunityManager()) {
            return BizResponse.fail("无权访问！");
        }
        com.yizhi.system.application.domain.Account account = accountService.selectById(context.getAccountId());

        String getTokenUrl = new StringBuffer(LOCATION).
                append(GET_TOKEN_URL).append(SYMBOL_1)
                .append(USERNAME).append(SYMBOL_2).append(context.getAccountName()).append(SYMBOL_3)
                .append(PASSWORD).append(SYMBOL_2).append(URLEncoder.encode(account.getPassword())).append(SYMBOL_3)
                .append(GRANT_TYPE).append(SYMBOL_2).append(PASSWORD).append(SYMBOL_3)
                .append(COMPANY_CODE).append(SYMBOL_2).append(context.getCompanyCode()).append(SYMBOL_3)
                .append(SITE_CODE).append(SYMBOL_2).append(context.getSiteCode()).toString();
        Map<String, String> headers = new HashMap<>();
        headers.put(AUTHORIZATION, CLIENT_MANAGE);
        headers.put(WMY_TOKEN_HEADER, JSON.toJSONString(context));
        logger.info("发送的url；" + getTokenUrl);

        JSONObject jsonObject = null;
        try {
            jsonObject = HttpClientUtils.httpPost(getTokenUrl, null, headers);
        } catch (Exception e) {
            return BizResponse.fail("获取access_token 失败，{}", e.getMessage());
        }
        if (Objects.isNull(jsonObject)) {
            return BizResponse.fail("获取access_token 失败！！！");
        }
        Object o = jsonObject.get(ACCESS_TOKEN);
        if (!Objects.isNull(o)) {
            return BizResponse.ok(o);
        } else {
            return BizResponse.fail("获取access_token 失败！！！");
        }
    }

    /**
     * 判断当前用户当前站点，是否有访问社群的权限
     */
    public void judgeWhetherIsCommunityManager(RequestContext context, List<AccessSite> accessSites) {
        if (context.getAccountId() == null) {
            return;
        }
        // 当前用户当前站点，是否有访问社群的权限
        try {
            if (CollectionUtils.isNotEmpty(accessSites)) {
                for (AccessSite a : accessSites) {
                    if (context.getSiteId().equals(a.getSiteId())) {
                        List<CommonTree> menus = a.getMenus();
                        if (CollectionUtils.isNotEmpty(menus)) {
                            for (CommonTree b : menus) {
                                if (CollectionUtils.isNotEmpty(b.getChildren())) {
                                    continue;
                                }
                                AuthzMenu authzMenu = null;
                                if (b.getNode() instanceof JSONObject) {
                                    authzMenu = JSON.parseObject(b.getNode().toString(), AuthzMenu.class);
                                } else authzMenu = (AuthzMenu) b.getNode();

                                if (authzMenu.getToCommunity()) {
                                    context.setIsCommunityManager(true);
                                    if (menus.size() == 1) {
                                        context.setIsOnlyCommunity(true);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("判断社群管理员出错：{}", e.getMessage());
        }
    }
}
