package com.yizhi.system.application.controller.manage;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.core.application.file.exp.ExcelExportor;
import com.yizhi.core.application.log.LogEventPublisher;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.system.application.constant.AuthzConstant;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.service.ISiteService;
import com.yizhi.system.application.vo.domain.Account;
import com.yizhi.util.application.domain.Response;
import com.yizhi.wechat.application.feign.WeiXinClient;
import com.yizhi.wechat.application.vo.wechat.domain.TrAccountUserinfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.log4j.Log4j2;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @Author: shengchenglong
 * @Date: 25/07/2018 17:23
 */
@Api(tags = "账号导出")
@RestController
@RequestMapping(value = "/manage/account/export")
@Log4j2
public class AccountExportController {

    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    private ISiteService siteService;
    @Autowired
    private IAccountService accountService;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private LogEventPublisher publisher;
    @Autowired
    private WeiXinClient weiXinClient;

    @ApiOperation(value = "用户导出")
    @GetMapping("/excel")
    public Response<String> accountExport(
            @ApiParam("用户名，模糊匹配") @RequestParam(name = "name", required = false) String name,
            @ApiParam("工号，模糊匹配") @RequestParam(name = "workNum", required = false) String workNum,
            @ApiParam("姓名，模糊匹配") @RequestParam(name = "fullName", required = false) String fullName,
            @ApiParam("邮箱，模糊匹配") @RequestParam(name = "email", required = false) String email,
            @ApiParam("部门id，精确匹配") @RequestParam(name = "orgId", required = false) Long orgId,
            @ApiParam("用户状态，精确匹配，1：启用，0：停用") @RequestParam(name = "enabled", required = false) Integer enabled
    ) {
        try {
            // 参数检查
            if (null == orgId) {
                return Response.fail("4001", InternationalEnums.ORGEXPORTCONTROLLER1.getCode());
            }
            com.yizhi.system.application.domain.Organization org = organizationService.selectById(Long.valueOf(String.valueOf(orgId)));
            if (org == null) {
                return Response.fail("4001", InternationalEnums.ORGEXPORTCONTROLLER2.getCode() + orgId);
            }

            // 开始处理
            RequestContext requestContext = ContextHolder.get();
            Date now = new Date();
            String serialNo = "USER-EXPORT-" + DateFormatUtils.format(now, "yyyyMMdd HH:mm:ss");
            TaskContext taskContext = new TaskContext(idGenerator.generate(), serialNo, "用户导出-" + org.getName(), requestContext.getAccountId(),
                    now, requestContext.getSiteId(), requestContext.getCompanyId());

            AccountExporter<Account> exportor = new AccountExporter<>(null, null, requestContext,
                    name, workNum, fullName, email, orgId, enabled);
            exportor.bindContext(taskContext);
            exportor.bindPublisher(publisher);
            taskExecutor.asynExecute(exportor);

            return Response.ok(serialNo);
        } catch (Exception e) {
            return Response.fail();
        }
    }

    /**
     * 查出导出部门范围
     *
     * @param orgId
     * @param requestContext
     * @return null:当前企业所有
     */
    private List<com.yizhi.system.application.domain.Organization> accountExportOrgRange(Long orgId, RequestContext requestContext) {
        // 1. all company situation：查询的组织是跟组织
        com.yizhi.system.application.domain.Organization organization = organizationService.selectById(orgId);
        if (organization.getCode().indexOf(AuthzConstant.DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX) != -1) {
            return null;
        }

        // 2. 导出部分组织人员信息：拼接参数
        List<com.yizhi.system.application.domain.Organization> organizations = organizationService.listChildren(orgId);
        return organizations;
    }

    /**
     * 获取账户list
     *
     * @param organizations
     * @return
     */
    private List<com.yizhi.system.application.domain.Account> accountExportList(List<com.yizhi.system.application.domain.Organization> organizations, String name, String workNum,
                                            String fullName, String email, Integer enabled, RequestContext requestContext) {
        // 部门范围
        Set<Long> orgIds = new HashSet<>();
        // 部门 id ： name(code) map集合
        Map<Long, String> orgNameMap = new HashMap<>();
        Map<Long, String> orgFullNameMap = new HashMap<>();
        Map<Long, String> orgCodeMap = new HashMap<>();

        // 组织不为空，用户都属于该组织
        if (CollectionUtils.isNotEmpty(organizations)) {
            for (com.yizhi.system.application.domain.Organization o : organizations) {
                orgIds.add(o.getId());
            }
        }
        // 公司下部门名称 map
        com.yizhi.system.application.domain.Organization organization = new com.yizhi.system.application.domain.Organization();
        organization.setDeleted(Boolean.valueOf(false));
        organization.setCompanyId(requestContext.getCompanyId());
        organizations = organizationService.selectList(new EntityWrapper<>(organization));
        for (com.yizhi.system.application.domain.Organization o : organizations) {
            orgNameMap.put(o.getId(), o.getName());
            orgCodeMap.put(o.getId(), o.getCode());
        }
        // 组装部门全名称
        String[] parentIdLayerArr = null;
        for (com.yizhi.system.application.domain.Organization o : organizations) {
            parentIdLayerArr = o.getParentIdLayer().split("_");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parentIdLayerArr.length; i++) {
                if (i == 0) {
                    sb.append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                } else {
                    sb.append("+").append(orgNameMap.get(Long.valueOf(parentIdLayerArr[i])));
                }
                orgFullNameMap.put(o.getId(), sb.toString());
            }
        }

        com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
        account.setCompanyId(requestContext.getCompanyId());
        if (null != enabled) {
            account.setEnabled(new Integer(1).equals(enabled) ? Boolean.valueOf(true) : Boolean.valueOf(false));
        }
        EntityWrapper<com.yizhi.system.application.domain.Account> ew = new EntityWrapper<>(account);
        if (StringUtils.isNotEmpty(name)) {
            ew.like("name", name);
        }
        if (StringUtils.isNotEmpty(workNum)) {
            ew.and().like("work_num", workNum);
        }
        if (StringUtils.isNotEmpty(fullName)) {
            ew.and().like("full_name", fullName);
        }
        if (StringUtils.isNotEmpty(email)) {
            ew.and().like("email", email);
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            ew.in("org_id", orgIds);
        }
        ew.orderBy("enabled", false);
        ew.orderBy("create_time");
        List<com.yizhi.system.application.domain.Account> accounts = accountService.selectList(ew);

        if (CollectionUtils.isNotEmpty(accounts)) {
            List<Long> accountIds = new ArrayList<>();
            for (com.yizhi.system.application.domain.Account a : accounts) {
                a.setWorkNum(null == a.getWorkNum() ? "" : a.getWorkNum());
                a.setFullName(null == a.getFullName() ? "" : a.getFullName());
                a.setPosition(null == a.getPosition() ? "" : a.getPosition());
                a.setMobile(null == a.getMobile() ? "" : a.getMobile());
                a.setEmail(null == a.getEmail() ? "" : a.getEmail());
                a.setWechat(null == a.getWechat() ? "" : a.getWechat());
                a.setEnabledState(a.getEnabled() ? "启用" : "停用");
                a.setOrgCode(orgCodeMap.get(a.getOrgId()));

                a.setRemarkFirst(a.getRemarkFirst());
                a.setRemarkSecond(a.getRemarkSecond());
                a.setRemarkThird(a.getRemarkThird());

                if (null != a.getCreateTime()) {
                    a.setCreateTimeStr(DateFormatUtils.format(a.getCreateTime(), "yyyy/MM/dd"));
                }
                if (null != a.getExpiredTime()) {
                    a.setExpiredTimeStr(DateFormatUtils.format(a.getExpiredTime(), "yyyy/MM/dd"));
                } else {
                    a.setExpiredTimeStr("");
                }
                //  过期类型(1长期，2周期，3天数)
                if (a.getExpiredType() == 1) {
                    a.setValidDaysStr("");
                    a.setExpiredTimeStr("长期有效");
                } else if (a.getExpiredType() == 2) {
                    a.setValidDaysStr((null == a.getStartTime() ? "" : DateFormatUtils.format(a.getStartTime(), "yyyy/MM/dd")) + " - " + (null == a.getEndTime() ? "" : DateFormatUtils.format(a.getEndTime(), "yyyy/MM/dd")));
                    a.setExpiredTimeStr(DateFormatUtils.format(a.getEndTime(), "yyyy/MM/dd"));
                } else {
                    a.setValidDaysStr(String.valueOf(a.getValidDays()));
                    a.setExpiredTimeStr(a.getExpiredTimeStr());
                }
                a.setOrgFullName(orgFullNameMap.get(a.getOrgId()));
                accountIds.add(a.getId());
            }
            Map<Long, TrAccountUserinfoVo> userinfoMap = new HashMap<>();

            try {
                int pageSize = 1000;
                double dcount = Double.valueOf(accountIds.size()) / Double.valueOf(pageSize);
                int pageCount = (int) Math.ceil(dcount);
                for (int index = 0; index < pageCount; index++) {
                    int fromIndex = index * pageSize;
                    int toIndex = (index + 1) * pageSize > accountIds.size() ? accountIds.size() : (index + 1) * pageSize;

                    List<Long> accountIdList = accountIds.subList(fromIndex, toIndex);
                    Long companyId = accounts.get(0).getCompanyId();
                    com.yizhi.wechat.application.vo.wechat.AuthorizeUsersVO authorizeUsersVO = new com.yizhi.wechat.application.vo.wechat.AuthorizeUsersVO();
                    authorizeUsersVO.setUserIds(accountIdList);
                    authorizeUsersVO.setRoleId(companyId);
                    Map<Long, TrAccountUserinfoVo> userRelations = weiXinClient.getUserRelations(authorizeUsersVO);
                    log.info("绑定微信的关系：{11}" + userRelations);
                    userinfoMap.putAll(userRelations);

                }
            } catch (Exception e) {
                log.info("返回异常：" + e);
            }
            accounts = accounts.parallelStream().map(a -> {
                a.setBindWeChatState(userinfoMap.get(a.getId()) != null ? "已经绑定" : "未绑定");
                return a;
            }).collect(Collectors.toList());
//            try {
//                Long companyId = accounts.get(0).getCompanyId();
//                AuthorizeUsersVO authorizeUsersVO = new AuthorizeUsersVO();
//                authorizeUsersVO.setUserIds(accountIds);
//                authorizeUsersVO.setRoleId(companyId);
//                Map<Long, TrAccountUserinfo> userRelations = weiXinClient.getUserRelations(authorizeUsersVO);
//                log.info("绑定微信的关系：{11}"+userRelations);
//                accounts = accounts.parallelStream().map(a -> {
//                    a.setBindWeChatState(userRelations.get(a.getId())!=null?"已经绑定":"未绑定");
//                    return a;
//                }).collect(Collectors.toList());
//            } catch (Exception e) {
//                log.info("返回异常："+e.getMessage());
//            }
        }
        log.info("返回accounts：" + accounts);
        return accounts;
    }


    private Template buildTemplate(RequestContext context) {
        Template template = new Template();
        List<TemplateColumn> columns = new ArrayList<>();
        int i = 1;
//        columns.add(new TemplateColumn("id", "用户id", i)); i++;
        columns.add(new TemplateColumn("name", "用户名", i));
        i++;
        columns.add(new TemplateColumn("workNum", "工号", i));
        i++;
        columns.add(new TemplateColumn("fullName", "姓名", i));
        i++;
        columns.add(new TemplateColumn("position", "职务", i));
        i++;
        columns.add(new TemplateColumn("orgFullName", "所在部门", i));
        i++;
//        columns.add(new TemplateColumn("orgCode", "所在部门编码", 7)); i++;
        columns.add(new TemplateColumn("mobile", "手机号", i));
        i++;
        columns.add(new TemplateColumn("email", "邮箱", i));
        i++;
        columns.add(new TemplateColumn("bindWeChatState", "绑定状态", i));
        i++;
        columns.add(new TemplateColumn("remarkFirst", "备注1", i));
        i++;
        columns.add(new TemplateColumn("remarkSecond", "备注2", i));
        i++;
        columns.add(new TemplateColumn("remarkThird", "备注3", i));
        i++;
//        columns.add(new TemplateColumn("wechat", "微信号", 10)); i++;
//        columns.add(new TemplateColumn("validDaysStr", "有效期", 11)); i++;
        columns.add(new TemplateColumn("enabledState", "用户状态", i));
        i++;
        columns.add(new TemplateColumn("createTimeStr", "创建时间", i));
        i++;
        columns.add(new TemplateColumn("expiredTimeStr", "有效期截止时间", i));
        template.setColumns(columns);
        Site site = siteService.selectById(context.getSiteId());
        template.setFileName(site.getName() + "_用户信息_" + DateFormatUtils.format(new Date(), "yyyyMMdd") + ".xls");
        template.setBrowserExport(false);
        return template;
    }

    /**
     * 导出实现
     *
     * @param <T>
     */
    class AccountExporter<T> extends ExcelExportor<T> {

        private RequestContext context;
        private String name;
        private String workNum;
        private String fullName;
        private String email;
        private Long orgId;
        private Integer enabled;

        public AccountExporter(Template template, List<T> data, RequestContext context, String name,
                               String workNum, String fullName, String email, Long orgId, Integer enabled) {
            super(template, data);
            this.context = context;
            this.name = name;
            this.workNum = workNum;
            this.fullName = fullName;
            this.email = email;
            this.orgId = orgId;
            this.enabled = enabled;
        }


        private void beforeRender() {
            List<com.yizhi.system.application.domain.Organization> organizations = accountExportOrgRange(orgId, context);
            List<com.yizhi.system.application.domain.Account> accounts = accountExportList(organizations, name, workNum, fullName, email, enabled, context);
            Template template = buildTemplate(context);
            this.template = template;
            this.data = (List<T>) accounts;
        }

        @Override
        public FileInfo render() {
            beforeRender();
            return super.render();
        }
    }

}
