package com.yizhi.system.application.controller.manage;


import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.system.application.service.IAuthzMenuService;
import com.yizhi.system.application.vo.AuthzMenuVo2;
import com.yizhi.system.application.vo.domain.AuthzMenu;
import com.yizhi.system.application.vo.domain.AuthzMenuResponse;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.system.application.vo.AuthzMenuVO;
import io.swagger.annotations.*;
import lombok.extern.log4j.Log4j2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

@Log4j2
@Api("权限菜单管理")
@RestController
@RequestMapping("/manage/authMenu")
public class AuthzMenuController {
    @Autowired
    IAuthzMenuService menuService;

    private static final Logger LOG = LoggerFactory.getLogger(AuthzMenuController.class);

    /**
     *
     * @param name
     * @param enabled
     * @return
     */
    @ApiOperation(value = "可根据条件进行查询 返回树形结构权限菜单", response = CommonTree.class)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "菜单名称", dataType = "String", required = false),
            @ApiImplicitParam(name = "菜单状态",  dataType = "Integer", required = false),
            @ApiImplicitParam(name = "菜单类别", dataType = "Integer", required = false)
    })
    @GetMapping("/treeList")
    Response<List<AuthzMenuVo2>> queryByCondition(String name, Integer enabled, Integer menuType) {
        return Response.ok(menuService.queryByCondition(name, enabled, menuType));
    }

    /**
     * 根据id查询菜单
     */
    @ApiOperation(value = "根据id查询 相应的权限菜单")
    @GetMapping("/getMenuById")
    Response<AuthzMenuVo2> getMenuById(Long id) {
        try {
            return Response.ok(menuService.getMenuById(id));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 根据id，进行修改
     *
     * @param authzMenu
     * @return
     */
    @ApiOperation(value = "修改菜单", response = Boolean.class)
    @PostMapping("/update")
    Response<Boolean> updateByAuthzMenu(@ApiParam(value = "authzMenu") @RequestBody AuthzMenuVo2 authzMenu) {
        try {
            AuthzMenuVo2 authzMenuVo2 = new AuthzMenuVo2();
            BeanUtils.copyProperties(authzMenu,authzMenuVo2);
            return Response.ok(menuService.updateByAuthzMenu(authzMenuVo2));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 删除菜单
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "删除菜单", response = Boolean.class)
    @GetMapping("/delete")
    Response<Boolean> deleteMenu( Long id) {
        try {
            return Response.ok(menuService.deleteMenu(id));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 添加菜单
     *
     * @param authzMenu
     * @return 0 失败 1 成功 2 添加菜单超过三级 3 有同名 4 添加的菜单层级和菜单类型不匹配
     */
    @ApiOperation(value = "添加菜单", response = Boolean.class)
    @PostMapping("/save")
    Response<Integer> saveMenu(@ApiParam(value = "authzMenu") @RequestBody com.yizhi.system.application.domain.AuthzMenu authzMenu) {
        try {
            if (authzMenu.getEnabled() == null || authzMenu.getOperationMenu() == null ||
                    authzMenu.getName() == null) {
                return Response.fail(InternationalEnums.AUTHZMENUCONTROLLER16.getCode());
            }
            return Response.ok(menuService.saveMenu(authzMenu));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }



    /**
     * 禁用 确认后下属该菜单及下属所有子菜单被禁用。
     * 启用 确认后仅启用该菜单。若母菜单未被启用，确认后提示母菜单未被启用，无法启用子菜单。
     *
     * @param authzMenu
     * @return
     * @auther:Gyg
     */
    @ApiOperation("权限菜单禁用/启用")
    @PostMapping("/upOrDown")
    Response<String> upOrDown(@ApiParam(value = "主要传递id和权限菜单当前状态码") @RequestBody AuthzMenu authzMenu) {
        if (authzMenu == null) {
            return Response.fail(InternationalEnums.AUTHZMENUCONTROLLER1.getCode());
        }
        AuthzMenuResponse authzMenuResponse = null;
        try {
            com.yizhi.system.application.domain.AuthzMenu authzMenu1 = new com.yizhi.system.application.domain.AuthzMenu();
            BeanUtils.copyProperties(authzMenu,authzMenu1);
            authzMenuResponse = menuService.upOrDown(authzMenu1);
            if ("fail".equals(authzMenuResponse.getCode())) {
                return Response.fail(authzMenuResponse.getMsg());
            } else {
                return Response.ok();
            }
        } catch (Exception e) {
            log.info("错误提示{}", e);
            return Response.ok("Menu.biz.error");
        }
    }

    /**
     * 上移、下移：同级菜单间可以上移下移（分隔符属于二级菜单）。
     * 同一母菜单下的菜单最上面一个上移置灰。最下面一个下移置灰。
     *
     * @return 0 失败 1 成功
     * @auther:Gyg
     */
    @ApiOperation("菜单排序")
    @PostMapping("/sort")
    Response<Integer> sortAuthzMenu(@RequestBody List<AuthzMenu> authzMenus) {
        try {
            List<com.yizhi.system.application.domain.AuthzMenu> list = new ArrayList<>();
            authzMenus.forEach(authzMenu -> {
                com.yizhi.system.application.domain.AuthzMenu authzMenu1 = new com.yizhi.system.application.domain.AuthzMenu();
                BeanUtils.copyProperties(authzMenu,authzMenu1);
                list.add(authzMenu1);

            });
            return Response.ok(menuService.sortAuthzMenu(list));
        } catch (Exception e) {
            log.info("错误提示：{}", e);
            return Response.fail(InternationalEnums.AUTHZMENUCONTROLLER2.getCode());
        }
    }

}
