package com.yizhi.system.application.controller.manage;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.orm.page.PageUtil;
import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.system.application.controller.assember.CompanyAssember;
import com.yizhi.system.application.mapper.CompanyContactorMapper;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.service.ISiteService;
import com.yizhi.system.application.vo.AccountRegisterVO;
import com.yizhi.system.application.vo.CompanyPageVO;
import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.system.application.vo.ContactorVO;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.page.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 公司管理前端控制器
 * </p>
 *
 * @author FEIDA.WANG
 * @date 2018.3.8
 * @since 1.0
 */
@Api(tags = "企业管理接口")
@RestController
@RequestMapping(value = "/manage/company")
public class CompanyController {

    private static final Logger logger = LoggerFactory.getLogger(CompanyController.class);

    @Autowired
    ICompanyService companyService;
    @Autowired
    IAccountService accountService;
    @Autowired
    CompanyAssember companyAssember;
    @Autowired
    DomainConverter converter;
    @Autowired
    ISiteService siteService;
    @Autowired
    CompanyContactorMapper companyContactorMapper;
    @Autowired
    RedisCache redisCache;
    /**
     * 根据条件查找公司信息  测试通过
     *
     * @param companyVO
     * @return
     */
    @ApiOperation(value = "查找公司信息", notes = "查找公司信息")
    @PostMapping(value = "/list")
    public Response<PageInfo<CompanyVO>> listCompanyByPage(@RequestBody CompanyPageVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            com.yizhi.system.application.domain.Company company = (com.yizhi.system.application.domain.Company) converter.toDO(companyVO, com.yizhi.system.application.domain.Company.class);
            PageInfo<com.yizhi.system.application.domain.Company> pageInfo = new PageInfo<>();
            pageInfo.setPageNo(companyVO.getPageNo());
            pageInfo.setPageSize(companyVO.getPageSize());
            Page<com.yizhi.system.application.domain.Company> page = companyService.list(company, PageUtil.vice(pageInfo));
            PageInfo<com.yizhi.system.application.domain.Company> pageInfo1 = PageUtil.versa(converter.toPageVO(page, com.yizhi.system.application.domain.Company.class));
            return Response.ok(pageInfo1);
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "查找公司信息", notes = "查找公司信息")
    @PostMapping(value = "/site/list")
    public Response<PageInfo<com.yizhi.system.application.domain.Site>> getCompanyId(@RequestBody CompanyPageVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            if (companyVO.getCompanyId() == null) {
                return Response.ok();
            }

            EntityWrapper<com.yizhi.system.application.domain.Site> where = QueryUtil.condition(new com.yizhi.system.application.domain.Site());
            where.where("enabled={0}", 1);
            where.and().eq("company_id", companyVO.getCompanyId());
            PageInfo<com.yizhi.system.application.domain.Site> pageInfo = new PageInfo<>();
            pageInfo.setPageNo(companyVO.getPageNo());
            pageInfo.setPageSize(50);
            Page<com.yizhi.system.application.domain.Site> page = siteService.selectPage(PageUtil.vice(pageInfo), where);
            return Response.ok(PageUtil.versa(converter.toPageVO(page, com.yizhi.system.application.domain.Site.class)));
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 插入企业信息   测试通过
     *
     * @param companyVO
     * @return
     */
    @ApiOperation(value = "插入企业信息", notes = "插入企业信息")
    @PostMapping(value = "/insert")
    public Response<String> insert(@RequestBody CompanyVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            Date expiredTime = companyVO.getExpiredTime();
            if(expiredTime == null){
                return Response.fail(InternationalEnums.COMPANYCONTROLLER.getCode());
            }
            com.yizhi.system.application.domain.Company companyNew = companyAssember.fromVO(companyVO);
            /*try {
                companyNew.setExpiredTime(DateUtil.parse(expiredTimeStr,"yyyy-MM-dd HH:mm:ss"));
            } catch (Exception e) {
                return Response.fail("输入服务到期时间有误");
            }*/
            com.yizhi.system.application.domain.Company company = new com.yizhi.system.application.domain.Company();
            BeanUtils.copyProperties(companyNew,company);
            companyService.insertDetail(company);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 修改企业信息
     *
     * @param companyVO
     * @return
     */
    @ApiOperation(value = "修改企业信息", notes = "修改企业信息")
    @PostMapping(value = "/update")
    public Response<String> update(@RequestBody CompanyVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            com.yizhi.system.application.domain.Company company = (com.yizhi.system.application.domain.Company) converter.toDO(companyVO, com.yizhi.system.application.domain.Company.class);
            Date expiredTime = companyVO.getExpiredTime();
            if(expiredTime == null){
                return Response.fail("请输入服务到期时间");
            }
            /*try {
                companyNew.setExpiredTime(DateUtil.parse(expiredTimeStr,"yyyy-MM-dd HH:mm:ss"));
            } catch (Exception e) {
                return Response.fail("输入服务到期时间有误");
            }*/
            AccountRegisterVO accountRegisterVO = companyVO.getSuperAdmin();
            Long superAdminId = accountRegisterVO.getId() == null ? null : Long.valueOf(accountRegisterVO.getId());
            String pwd = accountRegisterVO.getPassword();
            String name = accountRegisterVO.getName();

            if (superAdminId != null && (StringUtils.isNotBlank(pwd) || StringUtils.isNotBlank(name))) {
                com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
                account.setPassword(pwd);
                account.setId(superAdminId);
                account.setName(name);
                company.setSuperAdmin(account);
            } else {
                company.setSuperAdmin(null);
            }
            /*List<ContactorVO> contactorVOS = companyVO.getContactorVOs();
            if(CollectionUtils.isNotEmpty(contactorVOS)){
                List<CompanyContactor> contactors = converter.toDOList(contactorVOS,CompanyContactor.class);
                company.setContactors(contactors);
            }else{
                company.setContactors(null);
            }*/

            companyService.update(company);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 更改服务到期时间   测试通过  更改都无到期时间 参数不能转换 通过对象转换
     *
     * @param companyVO
     * @return
     */
    @ApiOperation(value = "更改服务到期时间", notes = "更改服务到期时间")
    @PostMapping(value = "/endtime/update")
    public Response<String> updateEndTime(@RequestBody CompanyVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            companyService.updateEndTime(companyAssember.fromVO(companyVO));
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 更改企业状态            测试通过
     *
     * @param companyVO
     * @return
     */
    @ApiOperation(value = "更改企业状态", notes = "更改企业状态")
    @PostMapping(value = "/status/update")
    public Response<String> updateState(@RequestBody CompanyVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            logger.info("companyVO =" + JSON.toJSONString(companyVO));
            companyService.updateState(companyVO.getId(), companyVO.getStatus());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        if(companyVO.getStatus().byteValue()==3){
            try {
                com.yizhi.system.application.domain.Company company = new com.yizhi.system.application.domain.Company();
                company.setId(companyVO.getId());
                com.yizhi.system.application.domain.Company resultCompany = companyService.selectOne(QueryUtil.condition(company));
                Object[] delItem = new Object[]{resultCompany.getCode()};
                redisCache.hdel(CacheNamespace.REDIS_COMPANIES, delItem);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Response.ok();
    }

    /**
     * 更改公司名字  测试通过
     *
     * @param companyVO
     * @return
     */
    @ApiOperation(value = "更改公司名字", notes = "更改公司名字")
    @PostMapping(value = "/name/update")
    public Response<String> updateCompanyName(@RequestBody CompanyVO companyVO) {
        logger.info("companyVO =" + JSON.toJSONString(companyVO));
        try {
            companyService.updateCompanyName(companyVO.getId(), companyVO.getName());
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 更改公司联系人  测试通过
     *
     * @param contactorVO
     * @return
     */
    @ApiOperation(value = "更改公司联系人", notes = "更改公司联系人")
    @PostMapping(value = "/contactor/update")
    public Response<String> updateContact(@RequestBody ContactorVO contactorVO) {
        logger.info("contactorVO =" + JSON.toJSONString(contactorVO));
        try {
            com.yizhi.system.application.domain.CompanyContactor obj = (com.yizhi.system.application.domain.CompanyContactor) converter.toDO(contactorVO, com.yizhi.system.application.domain.CompanyContactor.class);
            obj.setCompanyId(ContextHolder.get().getCompanyId());
            companyService.updateContact(obj);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 获取公司信息
     *
     * @return
     */
    @ApiOperation(value = "获取公司页面信息", notes = "获取公司页面信息")
    @GetMapping(value = "/get")
    public Response<CompanyVO> get(@RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize) {
        try {
            //return Response.ok(companyAssember.toVO(companyService.get(ContextHolder.get().getCompanyId())));
            Page<com.yizhi.system.application.domain.Company> data = companyService.getPage(ContextHolder.get().getCompanyId(),pageNo,pageSize);
            Pair<List<com.yizhi.system.application.domain.Company>, Map<String,Integer>> retData = PageUtil.split(data);
            List<com.yizhi.system.application.domain.Company> itemDatas = retData.getLeft();
            CompanyVO vo = new CompanyVO();
            if(CollectionUtils.isNotEmpty(itemDatas)){
                vo = companyAssember.toVO(itemDatas.get(0));
            }
            return Response.ok(vo,retData.getRight());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    /**
     * 获取公司信息
     *
     * @param companyId
     * @return
     */
    @ApiOperation(value = "获取公司页面信息", notes = "获取公司页面信息", response = CompanyVO.class)
    @GetMapping(value = "/companyId/get")
    public Response<CompanyVO> getByCompanyId(@RequestParam("companyId") Long companyId) {
        CompanyVO companyVO = new CompanyVO();
        try {
            com.yizhi.system.application.domain.Company company = companyService.selectById(companyId);

            BeanUtils.copyProperties(company, companyVO);
            com.yizhi.system.application.domain.Account account = new com.yizhi.system.application.domain.Account();
            account.setCompanyDefaultAdmin(1);
            account.setCompanyId(company.getId());
            List<com.yizhi.system.application.domain.Account> rets = accountService.selectList(QueryUtil.condition(account));

            if (CollectionUtils.isNotEmpty(rets)) {
                AccountRegisterVO registerVO = new AccountRegisterVO();
                com.yizhi.system.application.domain.Account account1 = rets.get(0);
                BeanUtils.copyProperties(account1, registerVO);
                //因为Account 和 AccountRegisterVo 的 id字段类型不一致 克隆的时候会丢失
                registerVO.setId(account1.getId().toString());

                registerVO.setPassword(null);
                companyVO.setSuperAdmin(registerVO);
            }
            com.yizhi.system.application.domain.CompanyContactor companyContactor = new com.yizhi.system.application.domain.CompanyContactor();
            companyContactor.setDeleted(false);
            companyContactor.setCompanyId(account.getCompanyId());
            List<com.yizhi.system.application.domain.CompanyContactor> retList = companyContactorMapper.selectList(QueryUtil.condition(companyContactor));
            if (CollectionUtils.isNotEmpty(retList)) {
                companyVO.setContactorVOs(converter.toDOList(retList, ContactorVO.class));
            }
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

        return Response.ok(companyVO);
    }

    /**
     * 新增联系人
     *
     * @param contactorVO
     * @return
     */
    @ApiOperation(value = "新增联系人", notes = "新增联系人")
    @PostMapping(value = "/contactor/add")
    public Response<String> addContactor(@RequestBody ContactorVO contactorVO) {
        logger.info("contactorVO =" + JSON.toJSONString(contactorVO));
        try {
            com.yizhi.system.application.domain.CompanyContactor contactor = (com.yizhi.system.application.domain.CompanyContactor) converter.toDO(contactorVO, com.yizhi.system.application.domain.CompanyContactor.class);
            contactor.setCompanyId(ContextHolder.get().getCompanyId());
            companyService.insertContact(contactor);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }

    /**
     * 删除联系人
     *
     * @param contactorVO
     * @return
     */
    @ApiOperation(value = "删除联系人", notes = "删除联系人")
    @PostMapping(value = "/contactor/delete")
    public Response<String> deleteContactor(@RequestBody ContactorVO contactorVO) {
        logger.info("contactorVO =" + JSON.toJSONString(contactorVO));
        try {
            com.yizhi.system.application.domain.CompanyContactor contactor = (com.yizhi.system.application.domain.CompanyContactor) converter.toDO(contactorVO, com.yizhi.system.application.domain.CompanyContactor.class);
            companyService.deleteContact(contactor);
        } catch (BizException be) {
            return Response.fail(be.getCode(), be.getMsg());
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
        return Response.ok();
    }
}
