package com.yizhi.system.application.controller.manage;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.exam.application.feign.ExamClient;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.live.application.vo.LiveActivityVO;
import com.yizhi.log.application.vo.TaskLogVO;
import com.yizhi.system.application.exception.AuthNoManagementException;
import com.yizhi.system.application.exception.AuthNotManageException;
import com.yizhi.live.application.feign.LiveActivityClient;
import com.yizhi.log.application.remote.RemoteTaskLogClient;
import com.yizhi.system.application.mapper.DaIndicatorLoginDayMapper;
import com.yizhi.system.application.mapper.LoginLogMapper;
import com.yizhi.system.application.model.AccessSite;
import com.yizhi.system.application.service.AuthService;
import com.yizhi.system.application.vo.*;
import com.yizhi.util.application.constant.TpActivityType;
import com.yizhi.util.application.domain.Response;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.util.application.tree.TreeUtil;
import com.yizhi.system.application.vo.domain.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @ClassName DashboardController
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-14 14:38
 * @Version 1.0
 */
@Api(tags = "dashboard 接口")
@RestController
@RequestMapping(value = "/manage/dashboard/")
public class DashboardController {

    @Autowired
    private LoginLogMapper loginLogMapper;
    @Autowired
    private DaIndicatorLoginDayMapper loginDayMapper;
    @Autowired
    private RemoteTaskLogClient taskLogClient;
    @Autowired
    private ExamClient examClient;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private LiveActivityClient liveActivityClient;
    @Autowired
    private AuthService authService;

    private static Logger logger = LoggerFactory.getLogger(DashboardController.class);
    private static SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat format1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private static Map<String, Integer> map = new HashMap<>();

    static {
        //value为排序值
        map.put("用户管理", 1);
        map.put("课程管理", 2);
        map.put("考试管理", 3);
        map.put("素材库", 4);
        map.put("项目管理", 5);
        map.put("调研管理", 6);
        map.put("任务管理", 7);
        map.put("门户管理", 8);
        map.put("消息管理", 9);
        map.put("角色管理", 10);
    }

    @ApiOperation("活跃用户比例")
    @GetMapping("activeAccount")
    public Response<com.yizhi.system.application.domain.DaIndicatorAccount> activeAccount() {
        com.yizhi.system.application.domain.DaIndicatorAccount obj = new com.yizhi.system.application.domain.DaIndicatorAccount();
        obj.setSiteId(ContextHolder.get().getSiteId());
        EntityWrapper<com.yizhi.system.application.domain.DaIndicatorAccount> ew = new EntityWrapper<>(obj);
        ew.orderBy("process_time", false);
        obj = obj.selectOne(ew);
        return Response.ok(obj);
    }

    @ApiOperation("课程学习总时长")
    @GetMapping("courseTime")
    public Response<com.yizhi.system.application.domain.DaIndicatorCourseTime> courseTime() {
        com.yizhi.system.application.domain.DaIndicatorCourseTime obj = new com.yizhi.system.application.domain.DaIndicatorCourseTime();
        obj.setSiteId(ContextHolder.get().getSiteId());
        EntityWrapper<com.yizhi.system.application.domain.DaIndicatorCourseTime> ew = new EntityWrapper<>(obj);
        ew.orderBy("process_time", false);
        obj = obj.selectOne(ew);
        return Response.ok(obj);
    }

    @ApiOperation("完成课程数")
    @GetMapping("courseFinish")
    public Response<com.yizhi.system.application.domain.DaIndicatorCourseFinish> courseFinish() {
        com.yizhi.system.application.domain.DaIndicatorCourseFinish obj = new com.yizhi.system.application.domain.DaIndicatorCourseFinish();
        obj.setSiteId(ContextHolder.get().getSiteId());
        EntityWrapper<com.yizhi.system.application.domain.DaIndicatorCourseFinish> ew = new EntityWrapper<>(obj);
        ew.orderBy("process_time", false);
        obj = obj.selectOne(ew);
        return Response.ok(obj);
    }

    @ApiOperation("项目通过率")
    @GetMapping("tpFinish")
    public Response<com.yizhi.system.application.domain.DaIndicatorTpFinish> tpFinish() {
        com.yizhi.system.application.domain.DaIndicatorTpFinish obj = new com.yizhi.system.application.domain.DaIndicatorTpFinish();
        obj.setSiteId(ContextHolder.get().getSiteId());
        EntityWrapper<com.yizhi.system.application.domain.DaIndicatorTpFinish> ew = new EntityWrapper<>(obj);
        ew.orderBy("process_time", false);
        obj = obj.selectOne(ew);
        return Response.ok(obj);
    }

    @ApiOperation("站点全员访问分布数据 - 昨天")
    @GetMapping("accountYesterday")
    public Response<DashboardAccountVO> accountYesterday() {
        Date yesterday = DateUtil.yesterday().toJdkDate();
        List<com.yizhi.system.application.domain.LoginLog> list = loginLogMapper.getListByDay(ContextHolder.get().getSiteId(), yesterday);

        DashboardAccountVO vo = new DashboardAccountVO();
        LinkedHashMap<String, DashboardAccountLineVO> lineVOTreeMap = new LinkedHashMap<>();

        //储存pc人次
        Map<Integer, Integer> pcMap = new HashMap<>();
        //储存移动人次
        Map<Integer, Integer> mobMap = new HashMap<>();
        //储存pc人数
        Map<Integer, Set<Long>> accountIdPcMap = new HashMap();
        //储存移动人数
        LinkedHashMap<Integer, Set<Long>> accountIdMobMap = new LinkedHashMap<>();


        //初始化
        for (int i = 0; i < 24; i++) {
            accountIdMobMap.put(i, new HashSet<>());
            accountIdPcMap.put(i, new HashSet<>());
        }

        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(item -> {
                String hour = DateUtil.format(item.getLoginDate(), "HH");
                Integer index = -1;
                if (hour != null) {
                    index = Integer.valueOf(hour);
                }

                //累加pc人数
                if (accountIdPcMap.containsKey(index)) {
                    Set<Long> accountIdSet = accountIdPcMap.get(index);
                    if (accountIdSet != null) {
                        if (item.getLoginType() == 1) {
                            accountIdSet.add(item.getAccountId());
                        }
                    }
                }
                //累加weixin人数
                if (accountIdMobMap.containsKey(index)) {
                    Set<Long> accountIdSet = accountIdMobMap.get(index);
                    if (accountIdSet != null) {
                        if (item.getLoginType() != 1) {
                            accountIdSet.add(item.getAccountId());
                        }
                    }
                }
                //累加当前时间的人次
                if (item.getLoginType() != 1) {
                    //微信端
                    mobMap.put(index, returnNotNull(mobMap.get(index)) + 1);
                } else {
                    //pc端
                    pcMap.put(index, returnNotNull(pcMap.get(index)) + 1);
                }
            });
        }
        for (Integer index : accountIdMobMap.keySet()) {
            DashboardAccountLineVO lineVO = new DashboardAccountLineVO();

            lineVO.setMobileNum(accountIdMobMap.get(index).size());
            lineVO.setMobileTimes(returnNotNull(mobMap.get(index)));
            lineVO.setPcNum(accountIdPcMap.get(index).size());
            lineVO.setPcTimes(returnNotNull(pcMap.get(index)));
            String i = returnIndex(index);
            lineVOTreeMap.put(i, lineVO);
        }
        //储存折线图数据
        vo.setLineChart(lineVOTreeMap);

        Long siteId = ContextHolder.get().getSiteId();
        LinkedHashMap<String, DashboardAccountPieVO> pieMap = new LinkedHashMap<>();
        com.yizhi.system.application.domain.DaIndicatorLoginDay accountLoginDay = loginDayMapper.selectByDay(siteId, yesterday);
        DaIndicatorLoginDay daIndicatorLoginDay = new DaIndicatorLoginDay();
        if (accountLoginDay != null) {
            logger.info("当天登录信息为：" + JSON.toJSONString(accountLoginDay));
            //存放饼图数据
            BeanUtils.copyProperties(accountLoginDay,daIndicatorLoginDay);
            pieMap = buildPieData(daIndicatorLoginDay, format.format(yesterday), pieMap);
        }
        vo.setPieChart(pieMap);
        return Response.ok(vo);
    }

    /**
     * 按天统计需要，返回x轴坐标名称
     *
     * @param index x轴坐标索引
     * @return
     */
    public String returnIndex(Integer index) {
        if (index != null) {
            switch (index) {
                case 0:
                    return "00:00-00:59";
                case 1:
                    return "01:00-01:59";
                case 2:
                    return "02:00-02:59";
                case 3:
                    return "03:00-03:59";
                case 4:
                    return "04:00-04:59";
                case 5:
                    return "05:00-05:59";
                case 6:
                    return "06:00-06:59";
                case 7:
                    return "07:00-07:59";
                case 8:
                    return "08:00-08:59";
                case 9:
                    return "09:00-09:59";
                case 10:
                    return "10:00-10:59";
                case 11:
                    return "11:00-11:59";
                case 12:
                    return "12:00-12:59";
                case 13:
                    return "13:00-13:59";
                case 14:
                    return "14:00-14:59";
                case 15:
                    return "15:00-15:59";
                case 16:
                    return "16:00-16:59";
                case 17:
                    return "17:00-17:59";
                case 18:
                    return "18:00-18:59";
                case 19:
                    return "19:00-19:59";
                case 20:
                    return "20:00-20:59";
                case 21:
                    return "21:00-21:59";
                case 22:
                    return "22:00-22:59";
                case 23:
                    return "23:00-23:59";
            }
        }
        return "00:00-00:00";
    }

    /**
     * 返回非空数据
     *
     * @param a
     * @return
     */
    private Integer returnNotNull(Integer a) {
        a = (a == null ? 0 : a);
        return a;
    }

    /**
     * 组装折线图数据，按周按月统计时需要
     *
     * @param accountLoginDay 一周或一个月的相关数据对象
     * @param lineMap         储存折线图数据对象
     * @param index           x轴坐标索引
     * @return
     */
    private LinkedHashMap<String, DashboardAccountLineVO> buildLineData(DaIndicatorLoginDay accountLoginDay, LinkedHashMap<String, DashboardAccountLineVO> lineMap, String index) {
        if (accountLoginDay != null) {
            DashboardAccountLineVO lineVO = new DashboardAccountLineVO();
            lineVO.setMobileNum(returnNotNull(accountLoginDay.getMobilePersonNum()));
            lineVO.setMobileTimes(returnNotNull(accountLoginDay.getMobilePersonTime()));
            lineVO.setPcNum(returnNotNull(accountLoginDay.getPcPersonNum()));
            lineVO.setPcTimes(returnNotNull(accountLoginDay.getPcPersonTime()));
            lineMap.put(index, lineVO);
        }
        return lineMap;
    }

    /**
     * 组装饼状图数据
     *
     * @param
     * @param accountLoginDay
     * @return
     */
    public LinkedHashMap<String, DashboardAccountPieVO> buildPieData(DaIndicatorLoginDay accountLoginDay, String index, LinkedHashMap<String, DashboardAccountPieVO> pieMap) {

        if (accountLoginDay == null) {
            return pieMap;
        }
        DashboardAccountPieVO pieVO = new DashboardAccountPieVO();
        //储存人次
        pieVO.setMixTimes(returnNotNull(accountLoginDay.getMixPersonTime()));
        pieVO.setMobileTimes(returnNotNull(accountLoginDay.getMobilePersonTime()));
        pieVO.setPcTimes(returnNotNull(accountLoginDay.getPcPersonTime()));
        //储存人数
        pieVO.setMixNum(returnNotNull(accountLoginDay.getMixPersonNum()));
        pieVO.setMobileNum(returnNotNull(accountLoginDay.getMobilePersonNum()));
        pieVO.setPcNum(returnNotNull(accountLoginDay.getPcPersonNum()));

        pieMap.put(index, pieVO);
        return pieMap;
    }

    @ApiOperation("站点全员访问分布数据 - 按周")
    @GetMapping("accountToWeek")
    public Response<DashboardAccountVO> accountToWeek() {
        SimpleDateFormat format2 = new SimpleDateFormat("MM-dd");
        Date today = DateUtil.date();
        DashboardAccountVO vo = new DashboardAccountVO();
        Long siteId = ContextHolder.get().getSiteId();

        LinkedHashMap<String, DashboardAccountPieVO> pieMap = new LinkedHashMap<>();
        LinkedHashMap<String, DashboardAccountLineVO> lineMap = new LinkedHashMap<>();

        //获取前八周的时间
        for (int i = 8; i >= 1; i--) {
            Date dateOfPreWeek = DateUtil.offset(today, DateField.DAY_OF_YEAR, (-7 * i));
            Date preStartDate = DateUtil.beginOfWeek(dateOfPreWeek);
            String index = format2.format(preStartDate) + "当周";
            Date preEndDate = DateUtil.endOfWeek(dateOfPreWeek);

            DaIndicatorLoginDay accountLoginDay = new DaIndicatorLoginDay();
            List<com.yizhi.system.application.domain.DaIndicatorLoginDay> daIndicatorLoginDays = loginDayMapper.selectDayToDay(siteId, preStartDate, preEndDate);
            //累加一周的数据
            accountLoginDay = calculateData(daIndicatorLoginDays);

            //构建饼图数据
            pieMap = buildPieData(accountLoginDay, index, pieMap);

            lineMap = buildLineData(accountLoginDay, lineMap, index);

        }
        //存放折线图数据
        vo.setLineChart(lineMap);
        //存放饼状图数据
        vo.setPieChart(pieMap);
        return Response.ok(vo);
    }


    @ApiOperation("站点全员访问分布数据 - 按月")
    @GetMapping("accountToMonth")
    public Response<DashboardAccountVO> accountToMonth() {

        Date today = DateUtil.date();
        DashboardAccountVO vo = new DashboardAccountVO();
        Long siteId = ContextHolder.get().getSiteId();


        LinkedHashMap<String, DashboardAccountLineVO> lineMap = new LinkedHashMap<>();
        LinkedHashMap<String, DashboardAccountPieVO> pieMap = new LinkedHashMap<>();

        //获取前八月的时间
        for (int i = 8; i >= 1; i--) {

            DateTime currentMonth = DateUtil.offsetMonth(today, -i);
            String index = currentMonth.getField(DateField.MONTH) + 1 + "月";
            pieMap.put(index, null);
            lineMap.put(index, null);
            DateTime dateTimeStart = DateUtil.beginOfMonth(currentMonth);
            DateTime dateTimeEnd = DateUtil.endOfMonth(currentMonth);

            //累加一个月的数据
            DaIndicatorLoginDay accountLoginDay = new DaIndicatorLoginDay();
            List<com.yizhi.system.application.domain.DaIndicatorLoginDay> daIndicatorLoginDays = loginDayMapper.selectDayToDay(siteId, dateTimeStart, dateTimeEnd);
            accountLoginDay = calculateData(daIndicatorLoginDays);

            //构建饼图数据
            pieMap = buildPieData(accountLoginDay, index, pieMap);
            //构建折线图数据
            lineMap = buildLineData(accountLoginDay, lineMap, index);
        }
        //存放折线图数据
        vo.setLineChart(lineMap);
        //存放饼状图数据
        vo.setPieChart(pieMap);
        return Response.ok(vo);
    }


    /**
     * 累加数据
     *
     * @param daIndicatorLoginDays
     * @return
     */
    public DaIndicatorLoginDay calculateData(List<com.yizhi.system.application.domain.DaIndicatorLoginDay> daIndicatorLoginDays) {
        DaIndicatorLoginDay tem = new DaIndicatorLoginDay();

        if (CollectionUtils.isNotEmpty(daIndicatorLoginDays)) {
            daIndicatorLoginDays.forEach(a -> {
                tem.setPersonNum(returnNotNull(tem.getPersonNum()) + returnNotNull(a.getPersonNum()));
                tem.setPersonTime(returnNotNull(tem.getPersonTime()) + returnNotNull(a.getPersonTime()));
                tem.setMixPersonNum(returnNotNull(tem.getMixPersonNum()) + returnNotNull(a.getMixPersonNum()));
                tem.setMixPersonTime(returnNotNull(tem.getMixPersonTime()) + returnNotNull(a.getMixPersonTime()));
                tem.setMobilePersonNum(returnNotNull(tem.getMobilePersonNum()) + returnNotNull(a.getMobilePersonNum()));
                tem.setMobilePersonTime(returnNotNull(tem.getMixPersonTime()) + returnNotNull(a.getMixPersonTime()));
                tem.setPcPersonNum(returnNotNull(tem.getPcPersonNum()) + returnNotNull(a.getPcPersonNum()));
                tem.setPcPersonTime(returnNotNull(tem.getPcPersonTime()) + returnNotNull(a.getPcPersonTime()));
            });
        }
        return tem;
    }

    @ApiOperation("代办事项")
    @GetMapping("accountReadyTask")
    public Response readyTask() throws AuthNotManageException, AuthNoManagementException {
        List<ReadyTaskVo> list = new ArrayList();

        List<String> menuNameLists = new ArrayList<>();
        RequestContext context = ContextHolder.get();

        List<AccessSite> accessSites = authService.getAccessSiteWithMenu(ContextHolder.get().getCompanyCode(), ContextHolder.get().getAccountId(), ContextHolder.get().getSiteId());
        if (CollectionUtils.isNotEmpty(accessSites)) {
            accessSites.forEach(a -> {
                if (context.getSiteId().equals(a.getSiteId())) {
                    List<CommonTree> menus = a.getMenus();
                    if (CollectionUtils.isNotEmpty(menus)) {
                        //获取树形结构的所有节点
                        List<CommonTree> allMenus = TreeUtil.traverseTree(menus);
                        if (CollectionUtils.isNotEmpty(allMenus)) {
                            allMenus.forEach(c -> {
                                menuNameLists.add(c.getName());
                            });

                        }
                    }
                }
            });
        }
        logger.info(JSON.toJSONString(menuNameLists));
        try {
            if (menuNameLists.contains("考试管理")) {
                logger.info("查询到考试管理！！！");
                //获取考试前七天的数据
                List<Exam> expireList = examClient.getExpireList();
                if (CollectionUtils.isNotEmpty(expireList)) {
                    expireList.forEach(a -> {
                        list.add(new ReadyTaskVo(a.getId(), a.getName(), a.getEndTime(), TpActivityType.TYPE_EXAM));
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("查询考试数据异常");
        }

        try {
            if (menuNameLists.contains("任务管理")) {
                //获取任务前七天的数据
                List<TaskLogVO> logList = taskLogClient.list();
                if (CollectionUtils.isNotEmpty(logList)) {
                    logList.forEach(a -> {
                        list.add(new ReadyTaskVo(a.getId(), a.getName(), a.getSubmitTime(), TpActivityType.TYPE_LOG));
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("查询任务数据异常");
        }

        try {
            if (menuNameLists.contains("直播管理")) {
                //获取直播前七天的数据
                List<LiveActivityVO> liveList = liveActivityClient.findWithinSevenDaysLive();
                if (CollectionUtils.isNotEmpty(liveList)) {
                    liveList.forEach(a -> {
                        list.add(new ReadyTaskVo(a.getId(), a.getTitle(), a.getEndTime(), TpActivityType.TYPE_LIVE));
                    });
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.info("查询直播数据异常");
        }

        if (CollectionUtils.isNotEmpty(list)) {
            //按结束时间倒序
            Collections.sort(list, new Comparator<ReadyTaskVo>() {
                @Override
                public int compare(ReadyTaskVo o1, ReadyTaskVo o2) {
                    Long diff = o2.getTaskEndDate().getTime() - o1.getTaskEndDate().getTime();
                    if (diff > 0) {
                        return 1;
                    } else if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
        }

        return Response.ok(list);
    }

    @ApiOperation("常用功能入口")
    @GetMapping("usedFunctions")
    public Response<List<UsedFunctionVo>> usedFunvtions() throws AuthNotManageException, AuthNoManagementException {

        List<UsedFunctionVo> list = new ArrayList<>();
        List<UsedFunctionVo> lists = new ArrayList<>();
        RequestContext context = ContextHolder.get();


        List<AccessSite> accessSites = authService.getAccessSiteWithMenu(ContextHolder.get().getCompanyCode(), ContextHolder.get().getAccountId(), ContextHolder.get().getSiteId());

        if (CollectionUtils.isNotEmpty(accessSites)) {
            accessSites.forEach(a -> {
                if (context.getSiteId().equals(a.getSiteId())) {
                    List<CommonTree> menus = a.getMenus();
                    if (CollectionUtils.isNotEmpty(menus)) {
                        //获取树形结构的所有节点
                        List<CommonTree> allMenus = TreeUtil.traverseTree(menus);
                        if (CollectionUtils.isNotEmpty(allMenus)) {
                            allMenus.forEach(c -> {
                                if (map.containsKey(c.getName())) {
                                    UsedFunctionVo vo = new UsedFunctionVo();
//                                                vo.setId(Long.valueOf(c.getId().toString()) );
                                    vo.setName(c.getName());
                                    String url = "";
                                    if (null != c.getNode()) {
                                        AuthzMenu authzMenu = null;
                                        if (c.getNode() instanceof AuthzMenu){
                                            authzMenu = (AuthzMenu) c.getNode();
                                        }else {
                                           authzMenu  = JSON.parseObject(c.getNode().toString(), AuthzMenu.class);
                                        }
                                        if (authzMenu != null) {
                                            url = authzMenu.getUrl();
                                            vo.setUrl(authzMenu.getUrl());
                                        }
                                    }
                                    vo.setSort(map.get(c.getName()));
                                    if (!StringUtils.isBlank(url)) {
                                        list.add(vo);
                                    }
                                }
                            });
                        }
                    }
                }
            });
        }


        if (CollectionUtils.isNotEmpty(list)) {

            Collections.sort(list, new Comparator<UsedFunctionVo>() {
                @Override
                public int compare(UsedFunctionVo o1, UsedFunctionVo o2) {
                    Integer diff = o1.getSort() - o2.getSort();
                    if (diff > 0) {
                        return 1;
                    } else if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            lists = limitFive(list);
        }

        return Response.ok(lists);
    }


    /**
     * 最多显示5条数据
     *
     * @param list
     * @return
     */
    public static List limitFive(List list) {
        List list1 = new ArrayList(5);
        if (CollectionUtils.isNotEmpty(list)) {

            if (list.size() > 5) {
                list1.add(list.get(0));
                list1.add(list.get(1));
                list1.add(list.get(2));
                list1.add(list.get(3));
                list1.add(list.get(4));
            } else {
                list1.addAll(list);
            }
        }
        return list1;
    }
}
