package com.yizhi.system.application.controller.manage;

import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.system.application.controller.remote.RemoteAccountRangeController;
import com.yizhi.system.application.mapper.AuthzGroupMemberMapper;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import com.yizhi.system.application.service.IAuthzGroupMemberService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Component
public class GroupMemberImport extends AbstractDefaultTask<String, Map<String, Object>> {


    private static final Logger LOGGER = LoggerFactory.getLogger(GroupMemberImport.class);

    @Autowired
    RemoteAccountRangeController remoteAccountRangeController;
    @Autowired
    IdGenerator idGenerator;
    @Autowired
    IAuthzGroupMemberService groupMemberService;
    @Autowired
    AuthzGroupMemberMapper authzGroupMemberMapper;


    @Override
    protected String execute(Map<String, Object> map) {
        //从map中取值
        String ossUrl = (String) map.get("ossUrl");
        RequestContext res = (RequestContext) map.get("requestContext");
        Long groupId = (Long) map.get("groupId");
        Long siteId = res.getSiteId();
        Long accountId = res.getAccountId();
        Long companyId = res.getCompanyId();
        Date submitTime = new Date();
        Long taskId = (Long) map.get("taskId");
        String serialNo = (String) map.get("serialNo");
        String taskName = (String) map.get("taskName");
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, accountId, submitTime, siteId, companyId);
        working(taskContext);

        //将请求值装入param中
        AccountRangeImportParam param = new AccountRangeImportParam();
        param.setOssUrl(ossUrl);
        param.setRequestContext(res);
        param.setType(AccountRangeImportParam.Type.SYSTEM);
        param.setGroupId(groupId);
        List<AccountRangeImportModel.SuccessAccount> successList = null;
        List<AccountRangeImportModel.ErrorAccount> errorList = null;
        List<Integer> integerList = null;

        //进行导入
        try {
            AccountRangeImportModel accountRangeImportModel = remoteAccountRangeController.doImport(param);
            if (null != accountRangeImportModel) {
                successList = accountRangeImportModel.getSuccessList();
                errorList = accountRangeImportModel.getErrorList();
            }
            //插入可见范围之前，先把该管辖区内的可见范围逻辑删除
            if (!CollectionUtils.isEmpty(successList)) {
                authzGroupMemberMapper.deleteByGroupId(groupId);
            }

            errorList = (errorList == null ? new ArrayList<>() : errorList);
            successList = (successList == null ? new ArrayList<>() : successList);

            //组装数据
            List<com.yizhi.system.application.domain.AuthzGroupMember> authzGroupMembers = new ArrayList<>();
            com.yizhi.system.application.domain.AuthzGroupMember authzGroupMember = null;
            if (!CollectionUtils.isEmpty(successList)){
                for (AccountRangeImportModel.SuccessAccount rangeImportModel : successList) {
                    authzGroupMember = new com.yizhi.system.application.domain.AuthzGroupMember();
                    authzGroupMember.setId(idGenerator.generate());
                    authzGroupMember.setGroupId(groupId);
                    authzGroupMember.setMemberId(rangeImportModel.getId());
                    authzGroupMember.setType(2);
                    authzGroupMember.setDeleted(0);
                    authzGroupMember.setCreateById(accountId);
                    authzGroupMember.setCreateTime(new Date());
                    authzGroupMember.setCreateByName(res.getAccountName());
                    authzGroupMembers.add(authzGroupMember);
                }
                groupMemberService.insertBatch(authzGroupMembers);
            }
            success(taskContext, "成功导入" + successList.size() + "条," + "导入失败" + errorList.size() + "条", ossUrl);

            List<String> errorMsgs = new ArrayList(errorList.size());
            errorList.forEach(a -> { errorMsgs.add("第" + a.getLine() + "行，" + a.getErrMsg()); });

            //写入错误信息
            batchTaskDetail(taskId,errorMsgs);

        } catch (Exception e) {
            e.printStackTrace();
            fail(taskContext, "管辖区可见范围异步导入过程中出现错误");
            LOGGER.error("管辖区可见范围异步导入过程中出现错误", e);
        }

        return "OK";
    }


}
