package com.yizhi.system.application.controller.manage;


import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.system.application.enums.ModuleType;
import com.yizhi.system.application.service.IInternationalizationService;
import com.yizhi.system.application.vo.domain.Internationalization;
import com.yizhi.util.application.domain.Response;
import com.yizhi.system.application.vo.InternationalizationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 国际化
 * </p>
 *
 * @author taoge123
 * @since 2020-03-17
 */
@RestController
@Api(tags = "国际化接口")
@RequestMapping("/manage/internationalization")
public class InternationalizationController {

    @Autowired
    private IInternationalizationService iInternationalizationService;

    private Logger logger = LoggerFactory.getLogger(InternationalizationController.class);

    @ApiOperation(value = "新增需要国际化的字段", notes = "新增国际化")
    @PostMapping(value = "/remote/add")
    public String add(@RequestBody Internationalization vo) {
        String name = vo.getName();
        String moduleType = vo.getModuleType();
        String result = "";
        if (name == null || name.trim().equals("") || vo.getModuleType() == null) {
            result = "name或者moduleType不能为空！";
            logger.info(result);

        }
        try {
            ModuleType.valueOf(moduleType);
        } catch (IllegalArgumentException e) {
            result = "moduleType值不存在或者不符合标准！";
            logger.info(result);
        }
        com.yizhi.system.application.domain.Internationalization internationalization = new com.yizhi.system.application.domain.Internationalization();
        BeanUtils.copyProperties(vo,internationalization);
        if (iInternationalizationService.add(internationalization) == 1) {
            result = "操作成功！";
        }
        result = "操作失败！";
        return result;
    }

    @ApiOperation(value = "修改需要国际化的字段", notes = "修改国际化")
    @PostMapping(value = "/remote/update")
    public String update(@RequestBody InternationalizationVo vo) {
        String name = vo.getName();
        String result = "";
        if (name == null || name.trim().equals("")) {
            result = "name不能为空！";
            logger.info(result);
        }

        if (iInternationalizationService.update(vo) == 1) {
            result = "操作成功！";
        }
        result = "操作失败！";
        return result;
    }

    @ApiOperation(value = "修改需要国际化的字段", notes = "前端用这个修改")
    @PostMapping(value = "/updateById")
    public Response<String> updateById(@RequestBody InternationalizationVo vo) {
        String name = vo.getName();
        Long id = vo.getId();
        if (name == null || name.trim().equals("") || id == null || id == 0) {
            return Response.fail(InternationalEnums.INTERNATIONALIZATIONCONTROLLER.getCode());
        }

        if (iInternationalizationService.update(vo) == 1) {
            return Response.ok("操作成功！");
        }
        return Response.fail(InternationalEnums.INTERNATIONALIZATIONWORDCONTROLLER4.getCode());
    }


    @ApiOperation(value = "获取需要国际化的字段列表", notes = "前端用这个获取列表", response = InternationalizationVo.class)
    @GetMapping(value = "/getPage")
    public Response<Page> getPage(@ApiParam("自定义名称") @RequestParam(value = "name", required = false) String name,
                                  @ApiParam("模块名称") @RequestParam(value = "moduleName", required = false) String moduleName,
                                  @ApiParam("语种") @RequestParam(value = "languageType") String languageType,
                                  @ApiParam("当前页数") @RequestParam(value = "pageNo", defaultValue = "1") Integer pageNo,
                                  @ApiParam("页内条数") @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize) {

        return Response.ok(iInternationalizationService.getPage(name, moduleName, languageType, pageNo, pageSize));
    }

    @ApiOperation(value = "删除需要国际化的字段", notes = "删除国际化")
    @PostMapping(value = "/remote/deleted")
    public String deleted(@RequestBody InternationalizationVo vo) {
        String result = "";
        if (iInternationalizationService.deleted(vo) == 1) {
            result = "操作成功！";
        }
        result = InternationalEnums.INTERNATIONALIZATIONWORDCONTROLLER4.getCode();
        return result;
    }
}

